/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.util.Assert;

public class DefaultRowMapperFactory
implements RowMapperFactory {
    private final JdbcAggregateOperations operations;
    private final QueryMappingConfiguration queryMappingConfiguration;

    public DefaultRowMapperFactory(JdbcAggregateOperations operations, QueryMappingConfiguration queryMappingConfiguration) {
        Assert.notNull((Object)operations, (String)"JdbcAggregateOperations must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        this.operations = operations;
        this.queryMappingConfiguration = queryMappingConfiguration;
    }

    @Override
    public RowMapper<Object> create(Class<?> returnedObjectType) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.operations.getConverter().getMappingContext().getPersistentEntity(returnedObjectType);
        if (persistentEntity == null) {
            return SingleColumnRowMapper.newInstance(returnedObjectType, (ConversionService)this.operations.getConverter().getConversionService());
        }
        return this.determineDefaultMapper(returnedObjectType);
    }

    private RowMapper<?> determineDefaultMapper(Class<?> returnedObjectType) {
        RowMapper<?> configuredQueryMapper = this.queryMappingConfiguration.getRowMapper(returnedObjectType);
        if (configuredQueryMapper != null) {
            return configuredQueryMapper;
        }
        return this.operations.getRowMapper(returnedObjectType);
    }
}

