/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.aot;

import java.sql.JDBCType;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.repository.query.JdbcParameters;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.ParameterBinding;
import org.springframework.data.relational.repository.query.ParameterMetadataProvider;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

class PlaceholderAccessor {
    PlaceholderAccessor() {
    }

    public static CapturingJdbcValue boundParameter(ParameterBinding binding) {
        return PlaceholderAccessor.boundParameter(null, binding);
    }

    public static CapturingJdbcValue boundParameter(@Nullable Object value, ParameterBinding binding) {
        return new CapturingJdbcValue(value, binding);
    }

    @Contract(value="null -> fail")
    public static CapturingJdbcValue unwrap(@Nullable Object value) {
        if (!(value instanceof CapturingJdbcValue) && value instanceof JdbcValue) {
            JdbcValue jv = (JdbcValue)value;
            value = jv.getValue();
        }
        if (value instanceof CapturingJdbcValue) {
            CapturingJdbcValue cp = (CapturingJdbcValue)value;
            return cp;
        }
        throw new IllegalArgumentException("Cannot unwrap value: '%s' to CapturingJdbcValue".formatted(value));
    }

    public static ParameterMetadataProvider metadata(RelationalParameterAccessor accessor) {
        return new CapturingParameterMetadataProvider(accessor);
    }

    public static RelationalParametersParameterAccessor capture(JdbcQueryMethod queryMethod, Object[] parameterValues, JdbcParameters parameters, RelationalParameters bindable) {
        return new CapturingParameterAccessor(queryMethod, parameterValues, parameters, bindable);
    }

    static class CapturingJdbcValue
    extends JdbcValue {
        private final ParameterBinding binding;

        private CapturingJdbcValue(@Nullable Object value, ParameterBinding binding) {
            super(value, JDBCType.OTHER);
            Assert.notNull((Object)binding, (String)"Parameter binding must not be null");
            this.binding = binding;
        }

        public ParameterBinding getBinding() {
            return this.binding;
        }

        public CapturingJdbcValue withValue(@Nullable Object value) {
            if (value == this) {
                return this;
            }
            return new CapturingJdbcValue(value, this.binding);
        }

        public CapturingJdbcValue withBinding(ParameterBinding binding) {
            return new CapturingJdbcValue(this.getValue(), binding);
        }
    }

    static class CapturingParameterMetadataProvider
    extends ParameterMetadataProvider {
        public CapturingParameterMetadataProvider(RelationalParameterAccessor accessor) {
            super(accessor);
        }

        protected @Nullable Object prepareParameterValue(@Nullable Object value, Class<?> valueType, Part.Type partType) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            CapturingJdbcValue capturingJdbcValue = (CapturingJdbcValue)value;
            if (partType == Part.Type.STARTING_WITH || partType == Part.Type.ENDING_WITH || partType == Part.Type.CONTAINING || partType == Part.Type.NOT_CONTAINING) {
                return JdbcValue.of(capturingJdbcValue.withBinding(ParameterBinding.like(capturingJdbcValue.getBinding(), partType)), JDBCType.OTHER);
            }
            return JdbcValue.of(capturingJdbcValue.withValue(super.prepareParameterValue(value, valueType, partType)), JDBCType.OTHER);
        }
    }

    static class CapturingParameterAccessor
    extends RelationalParametersParameterAccessor {
        private final JdbcParameters parameters;
        private final RelationalParameters bindable;

        public CapturingParameterAccessor(JdbcQueryMethod queryMethod, Object[] parameterValues, JdbcParameters parameters, RelationalParameters bindable) {
            super((QueryMethod)queryMethod, parameterValues);
            this.parameters = parameters;
            this.bindable = bindable;
        }

        public Sort getSort() {
            return Sort.unsorted();
        }

        public Pageable getPageable() {
            return Pageable.unpaged();
        }

        public @Nullable Object[] getValues() {
            return super.getValues();
        }

        protected <T> @Nullable T getValue(int index) {
            return (T)this.capture(this.parameters.getParameter(index));
        }

        public @Nullable Object getBindableValue(int index) {
            return this.capture((RelationalParameters.RelationalParameter)this.bindable.getParameter(index));
        }

        private CapturingJdbcValue capture(RelationalParameters.RelationalParameter parameter) {
            return PlaceholderAccessor.boundParameter(ParameterBinding.named(parameter.getRequiredName(), ParameterBinding.ParameterOrigin.ofParameter(parameter.getIndex())));
        }
    }
}

