/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Map;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SqlGeneratorSource {
    private final Map<Class<?>, SqlGenerator> CACHE = new ConcurrentReferenceHashMap();
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final Dialect dialect;

    public SqlGeneratorSource(JdbcConverter converter, Dialect dialect) {
        this(converter.getMappingContext(), converter, dialect);
    }

    public SqlGeneratorSource(RelationalMappingContext context, JdbcConverter converter, Dialect dialect) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        Assert.notNull((Object)converter, (String)"Converter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public SqlGenerator getSqlGenerator(Class<?> domainType) {
        return this.CACHE.computeIfAbsent(domainType, t -> new SqlGenerator(this.context, this.converter, (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(t), this.dialect));
    }
}

