/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.query.DefaultRowMapperFactory;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;

public class BeanFactoryAwareRowMapperFactory
extends DefaultRowMapperFactory {
    @Nullable
    private final BeanFactory beanFactory;

    BeanFactoryAwareRowMapperFactory(JdbcConverter converter, QueryMappingConfiguration queryMappingConfiguration, EntityCallbacks entityCallbacks, ApplicationEventPublisher publisher, @Nullable BeanFactory beanFactory) {
        super(converter, queryMappingConfiguration, entityCallbacks, publisher);
        this.beanFactory = beanFactory;
    }

    public BeanFactoryAwareRowMapperFactory(RelationalMappingContext context, JdbcConverter converter, QueryMappingConfiguration queryMappingConfiguration, EntityCallbacks entityCallbacks, ApplicationEventPublisher publisher, @Nullable BeanFactory beanFactory) {
        super(context, converter, queryMappingConfiguration, entityCallbacks, publisher);
        this.beanFactory = beanFactory;
    }

    @Override
    public RowMapper<Object> getRowMapper(String reference) {
        if (this.beanFactory == null) {
            throw new IllegalStateException("Cannot resolve RowMapper bean reference '" + reference + "'; BeanFactory is not configured.");
        }
        return (RowMapper)this.beanFactory.getBean(reference, RowMapper.class);
    }

    @Override
    public ResultSetExtractor<Object> getResultSetExtractor(String reference) {
        if (this.beanFactory == null) {
            throw new IllegalStateException("Cannot resolve ResultSetExtractor bean reference '" + reference + "'; BeanFactory is not configured.");
        }
        return (ResultSetExtractor)this.beanFactory.getBean(reference, ResultSetExtractor.class);
    }
}

