/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.cql.Statement;
import io.micrometer.observation.Observation;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.cassandra.observability.CassandraObservationSupplier;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

final class ObservationStatement
implements MethodInterceptor {
    private final Observation observation;
    private Statement<?> delegate;

    private ObservationStatement(Observation observation, Statement<?> delegate) {
        this.observation = observation;
        this.delegate = delegate;
    }

    public static <T> T createProxy(Observation observation, T target) {
        ProxyFactory factory = new ProxyFactory(ClassUtils.getAllInterfaces(target));
        factory.addInterface(CassandraObservationSupplier.class);
        factory.setTarget(target);
        factory.addAdvice((Advice)new ObservationStatement(observation, (Statement)target));
        return (T)factory.getProxy();
    }

    public static boolean isObservationStatement(Statement<?> statement) {
        return statement instanceof CassandraObservationSupplier;
    }

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String name;
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        switch (name = method.getName()) {
            case "equals": {
                if (args.length != 1) break;
                return this.equals(args[0]);
            }
            case "hashCode": {
                return this.hashCode();
            }
            case "getTargetClass": {
                return this.delegate.getClass();
            }
            case "getObservation": {
                return this.observation;
            }
        }
        Object result = invocation.proceed();
        if (result instanceof Statement) {
            this.delegate = (Statement)result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ObservationStatement)) {
            return false;
        }
        ObservationStatement that = (ObservationStatement)o;
        return ObjectUtils.nullSafeEquals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash((Object[])new Object[]{this.delegate});
    }
}

