/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConversionException;

class ApplicationJsonMessageMarshallingConverter
extends MappingJackson2MessageConverter {
    private final Map<Type, JavaType> typeCache = new ConcurrentHashMap<Type, JavaType>();

    ApplicationJsonMessageMarshallingConverter(@Nullable ObjectMapper objectMapper) {
        if (objectMapper != null) {
            this.setObjectMapper(objectMapper);
        }
    }

    protected Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        if (payload instanceof byte[]) {
            return payload;
        }
        if (payload instanceof String) {
            return ((String)payload).getBytes(StandardCharsets.UTF_8);
        }
        return super.convertToInternal(payload, headers, conversionHint);
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object hint) {
        if (message.getPayload().getClass().getName().startsWith("org.springframework.kafka.support.KafkaNull")) {
            return null;
        }
        Object conversionHint = hint;
        Object result = null;
        if (conversionHint instanceof MethodParameter) {
            Class conversionHintType = ((MethodParameter)conversionHint).getParameterType();
            if (Message.class.isAssignableFrom(conversionHintType)) {
                conversionHint = null;
            } else if (((MethodParameter)conversionHint).getGenericParameterType() instanceof ParameterizedType) {
                ParameterizedTypeReference forType = ParameterizedTypeReference.forType((Type)((MethodParameter)conversionHint).getGenericParameterType());
                result = this.convertParameterizedType(message, forType.getType());
            }
        } else if (conversionHint instanceof ParameterizedTypeReference) {
            result = this.convertParameterizedType(message, ((ParameterizedTypeReference)conversionHint).getType());
        } else if (conversionHint instanceof ParameterizedType) {
            result = this.convertParameterizedType(message, (Type)conversionHint);
        }
        if (result == null) {
            result = message.getPayload() instanceof byte[] && String.class.isAssignableFrom(targetClass) ? new String((byte[])message.getPayload(), StandardCharsets.UTF_8) : super.convertFromInternal(message, targetClass, conversionHint);
        }
        return result;
    }

    private Object convertParameterizedType(Message<?> message, Type conversionHint) {
        ObjectMapper objectMapper = this.getObjectMapper();
        Object payload = message.getPayload();
        try {
            JavaType type = this.typeCache.get(conversionHint);
            if (type == null) {
                conversionHint = FunctionTypeUtils.isMessage((Type)conversionHint) ? FunctionTypeUtils.getImmediateGenericType((Type)conversionHint, (int)0) : conversionHint;
                type = objectMapper.getTypeFactory().constructType(conversionHint);
                this.typeCache.put(conversionHint, type);
            }
            if (payload instanceof byte[]) {
                return objectMapper.readValue((byte[])payload, type);
            }
            if (payload instanceof String) {
                return objectMapper.readValue((String)payload, type);
            }
            JavaType typeToUse = type;
            if (payload instanceof Collection) {
                Collection collection = ((Collection)payload).stream().map(value -> {
                    try {
                        if (value instanceof byte[]) {
                            return objectMapper.readValue((byte[])value, typeToUse.getContentType());
                        }
                        if (value instanceof String) {
                            return objectMapper.readValue((String)value, typeToUse.getContentType());
                        }
                        return objectMapper.convertValue(value, typeToUse.getContentType());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Failed to convert payload " + value), (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
                return collection;
            }
            return null;
        }
        catch (IOException e) {
            throw new MessageConversionException("Cannot parse payload ", (Throwable)e);
        }
    }
}

