/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.TraceContext;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.sleuth.brave.bridge.BraveFinishedSpan;
import org.springframework.cloud.sleuth.exporter.SpanFilter;

public class CompositeSpanHandler
extends SpanHandler {
    private final List<SpanFilter> exporters;

    public CompositeSpanHandler(List<SpanFilter> exporters) {
        this.exporters = exporters == null ? Collections.emptyList() : exporters;
    }

    public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
        if (cause != SpanHandler.Cause.FINISHED) {
            return true;
        }
        boolean shouldProcess = this.shouldProcess(span);
        if (!shouldProcess) {
            return false;
        }
        return super.end(context, span, cause);
    }

    private boolean shouldProcess(MutableSpan span) {
        for (SpanFilter exporter : this.exporters) {
            if (exporter.isExportable(BraveFinishedSpan.fromBrave(span))) continue;
            return false;
        }
        return true;
    }
}

