/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.SecretsCache;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.core.log.LogAccessor;

final class Fabric8SecretsCache
implements SecretsCache {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(Fabric8SecretsCache.class));
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> CACHE = new ConcurrentHashMap();

    Fabric8SecretsCache() {
    }

    public void discardAll() {
        CACHE.clear();
    }

    static List<StrippedSourceContainer> byNamespace(KubernetesClient client, String namespace) {
        boolean[] b = new boolean[1];
        List result = CACHE.computeIfAbsent(namespace, x -> {
            b[0] = true;
            return Fabric8SecretsCache.strippedSecrets(((SecretList)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).list()).getItems());
        });
        if (b[0]) {
            LOG.debug(() -> "Loaded all secrets in namespace '" + namespace + "'");
        } else {
            LOG.debug(() -> "Loaded (from cache) all secrets in namespace '" + namespace + "'");
        }
        return result;
    }

    private static List<StrippedSourceContainer> strippedSecrets(List<Secret> secrets) {
        return secrets.stream().map(secret -> new StrippedSourceContainer(secret.getMetadata().getLabels(), secret.getMetadata().getName(), secret.getData())).collect(Collectors.toList());
    }
}

