/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.config.reload;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class EventBasedConfigMapChangeDetector
extends ConfigurationChangeDetector {
    private final Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator;
    private final Map<String, Watch> watches;
    private KubernetesClient kubernetesClient;

    public EventBasedConfigMapChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.kubernetesClient = kubernetesClient;
        this.fabric8ConfigMapPropertySourceLocator = fabric8ConfigMapPropertySourceLocator;
        this.watches = new HashMap<String, Watch>();
    }

    @PreDestroy
    public void shutdown() {
        this.kubernetesClient.close();
    }

    @PostConstruct
    public void watch() {
        boolean activated = false;
        if (this.properties.isMonitoringConfigMaps()) {
            try {
                final String name = "config-maps-watch-event";
                this.watches.put(name, this.kubernetesClient.configMaps().watch((Object)new Watcher<ConfigMap>(){

                    public void eventReceived(Watcher.Action action, ConfigMap configMap) {
                        if (EventBasedConfigMapChangeDetector.this.log.isDebugEnabled()) {
                            EventBasedConfigMapChangeDetector.this.log.debug((Object)(name + " received event for ConfigMap " + configMap.getMetadata().getName()));
                        }
                        EventBasedConfigMapChangeDetector.this.onEvent(configMap);
                    }

                    public void onClose(WatcherException exception) {
                        EventBasedConfigMapChangeDetector.this.log.warn((Object)"ConfigMaps watch closed", (Throwable)exception);
                        Optional.ofNullable(exception).map(e -> {
                            EventBasedConfigMapChangeDetector.this.log.debug((Object)"Exception received during watch", (Throwable)e);
                            return exception.asClientException();
                        }).map(KubernetesClientException::getStatus).map(Status::getCode).filter(c -> c.equals(410)).ifPresent(c -> EventBasedConfigMapChangeDetector.this.watch());
                    }
                }));
                activated = true;
                this.log.info((Object)("Added new Kubernetes watch: " + name));
            }
            catch (Exception e) {
                this.log.error((Object)"Error while establishing a connection to watch config maps: configuration may remain stale", (Throwable)e);
            }
        }
        if (activated) {
            this.log.info((Object)"Kubernetes event-based configMap change detector activated");
        }
    }

    @PreDestroy
    public void unwatch() {
        if (this.watches != null) {
            for (Map.Entry<String, Watch> entry : this.watches.entrySet()) {
                try {
                    this.log.debug((Object)("Closing the watch " + entry.getKey()));
                    entry.getValue().close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Error while closing the watch connection", (Throwable)e);
                }
            }
        }
    }

    protected void onEvent(ConfigMap configMap) {
        this.log.debug((Object)String.format("onEvent configMap: %s", configMap.toString()));
        boolean changed = this.changed(this.locateMapPropertySources((PropertySourceLocator)this.fabric8ConfigMapPropertySourceLocator, (Environment)this.environment), this.findPropertySources(Fabric8ConfigMapPropertySource.class));
        if (changed) {
            this.log.info((Object)"Detected change in config maps");
            this.reloadProperties();
        }
    }
}

