/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.core.env.Environment;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public class KubernetesConfigDataResource
extends ConfigDataResource {
    private final KubernetesClientProperties properties;
    private final ConfigMapConfigProperties configMapProperties;
    private final SecretsConfigProperties secretsConfigProperties;
    private final boolean optional;
    private final Profiles profiles;
    private Log log;
    private Environment environment;

    public KubernetesConfigDataResource(KubernetesClientProperties properties, ConfigMapConfigProperties configMapProperties, SecretsConfigProperties secretsConfigProperties, boolean optional, Profiles profiles, Environment environment) {
        this.properties = properties;
        this.configMapProperties = configMapProperties;
        this.secretsConfigProperties = secretsConfigProperties;
        this.optional = optional;
        this.profiles = profiles;
        this.environment = environment;
    }

    public KubernetesClientProperties getProperties() {
        return this.properties;
    }

    public ConfigMapConfigProperties getConfigMapProperties() {
        return this.configMapProperties;
    }

    public SecretsConfigProperties getSecretsConfigProperties() {
        return this.secretsConfigProperties;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getProfiles() {
        return StringUtils.collectionToCommaDelimitedString(this.getAcceptedProfiles());
    }

    List<String> getAcceptedProfiles() {
        return this.profiles.getAccepted();
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KubernetesConfigDataResource that = (KubernetesConfigDataResource)((Object)o);
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.optional, that.optional) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.configMapProperties, that.configMapProperties) && Objects.equals(this.secretsConfigProperties, that.secretsConfigProperties);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.optional, this.profiles, this.configMapProperties, this.secretsConfigProperties);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("optional", this.optional).append("profiles", (Object)this.profiles.getAccepted()).toString();
    }
}

