/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import shaded.org.eclipse.aether.impl.ArtifactResolver;
import shaded.org.eclipse.aether.impl.OfflineController;
import shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import shaded.org.eclipse.aether.impl.RepositoryConnectorProvider;
import shaded.org.eclipse.aether.impl.RepositoryEventDispatcher;
import shaded.org.eclipse.aether.impl.SyncContextFactory;
import shaded.org.eclipse.aether.impl.UpdateCheck;
import shaded.org.eclipse.aether.impl.UpdateCheckManager;
import shaded.org.eclipse.aether.impl.VersionResolver;
import shaded.org.eclipse.aether.internal.impl.SafeTransferListener;
import shaded.org.eclipse.aether.internal.impl.Utils;
import shaded.org.eclipse.aether.spi.connector.ArtifactDownload;
import shaded.org.eclipse.aether.spi.connector.RepositoryConnector;
import shaded.org.eclipse.aether.spi.io.FileProcessor;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.eclipse.aether.spi.log.LoggerFactory;

@Named
public class DefaultArtifactResolver
implements ArtifactResolver,
Service {
    private static final String CONFIG_PROP_SNAPSHOT_NORMALIZATION = "aether.artifactResolver.snapshotNormalization";
    private static final Logger LOGGER = org.slf4j.LoggerFactory.getLogger(DefaultArtifactResolver.class);
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private VersionResolver versionResolver;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultArtifactResolver() {
    }

    @Inject
    DefaultArtifactResolver(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, VersionResolver versionResolver, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setVersionResolver(versionResolver);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    @Deprecated
    public DefaultArtifactResolver setLoggerFactory(LoggerFactory loggerFactory) {
        return this;
    }

    public DefaultArtifactResolver setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultArtifactResolver setVersionResolver(VersionResolver versionResolver) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "version resolver cannot be null");
        return this;
    }

    public DefaultArtifactResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultArtifactResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultArtifactResolver setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        return this.resolveArtifacts(session, Collections.singleton(request)).get(0);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session, false);){
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(requests.size());
            for (ArtifactRequest artifactRequest : requests) {
                if (artifactRequest.getArtifact().getProperty("localPath", null) != null) continue;
                artifacts.add(artifactRequest.getArtifact());
            }
            syncContext.acquire(artifacts, null);
            List<ArtifactResult> list = this.resolve(session, requests);
            return list;
        }
    }

    private List<ArtifactResult> resolve(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        ArrayList<ArtifactResult> results = new ArrayList<ArtifactResult>(requests.size());
        boolean failures = false;
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        WorkspaceReader workspace = session.getWorkspaceReader();
        ArrayList<ResolutionGroup> groups = new ArrayList<ResolutionGroup>();
        for (ArtifactRequest artifactRequest : requests) {
            File file;
            VersionResult versionResult;
            RequestTrace trace = RequestTrace.newChild(artifactRequest.getTrace(), artifactRequest);
            ArtifactResult result = new ArtifactResult(artifactRequest);
            results.add(result);
            Artifact artifact = artifactRequest.getArtifact();
            List<RemoteRepository> repos = artifactRequest.getRepositories();
            this.artifactResolving(session, trace, artifact);
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null) {
                File file2 = new File(localPath);
                if (!file2.isFile()) {
                    failures = true;
                    result.addException(new ArtifactNotFoundException(artifact, null));
                    continue;
                }
                artifact = artifact.setFile(file2);
                result.setArtifact(artifact);
                this.artifactResolved(session, trace, artifact, null, result.getExceptions());
                continue;
            }
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, repos, artifactRequest.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
            }
            catch (VersionResolutionException e) {
                result.addException(e);
                continue;
            }
            artifact = artifact.setVersion(versionResult.getVersion());
            if (versionResult.getRepository() != null) {
                repos = versionResult.getRepository() instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)versionResult.getRepository()) : Collections.emptyList();
            }
            if (workspace != null && (file = workspace.findArtifact(artifact)) != null) {
                artifact = artifact.setFile(file);
                result.setArtifact(artifact);
                result.setRepository(workspace.getRepository());
                this.artifactResolved(session, trace, artifact, result.getRepository(), null);
                continue;
            }
            LocalArtifactResult local = lrm.find(session, new LocalArtifactRequest(artifact, repos, artifactRequest.getRequestContext()));
            if (this.isLocallyInstalled(local, versionResult)) {
                if (local.getRepository() != null) {
                    result.setRepository(local.getRepository());
                } else {
                    result.setRepository(lrm.getRepository());
                }
                try {
                    artifact = artifact.setFile(this.getFile(session, artifact, local.getFile()));
                    result.setArtifact(artifact);
                    this.artifactResolved(session, trace, artifact, result.getRepository(), null);
                }
                catch (ArtifactTransferException e) {
                    result.addException(e);
                }
                if (local.isAvailable()) continue;
                lrm.add(session, new LocalArtifactRegistration(artifact));
                continue;
            }
            if (local.getFile() != null) {
                LOGGER.debug("Verifying availability of {} from {}", (Object)local.getFile(), repos);
            }
            AtomicBoolean resolved = new AtomicBoolean(false);
            Iterator<Object> groupIt = groups.iterator();
            for (RemoteRepository repo : repos) {
                if (!repo.getPolicy(artifact.isSnapshot()).isEnabled()) continue;
                try {
                    Utils.checkOffline(session, this.offlineController, repo);
                }
                catch (RepositoryOfflineException e) {
                    ArtifactNotFoundException exception = new ArtifactNotFoundException(artifact, repo, "Cannot access " + repo.getId() + " (" + repo.getUrl() + ") in offline mode and the artifact " + artifact + " has not been downloaded from it before.", e);
                    result.addException(exception);
                    continue;
                }
                ResolutionGroup group = null;
                while (groupIt.hasNext()) {
                    ResolutionGroup t = (ResolutionGroup)groupIt.next();
                    if (!t.matches(repo)) continue;
                    group = t;
                    break;
                }
                if (group == null) {
                    group = new ResolutionGroup(repo);
                    groups.add(group);
                    groupIt = Collections.emptyList().iterator();
                }
                group.items.add(new ResolutionItem(trace, artifact, resolved, result, local, repo));
            }
        }
        for (ResolutionGroup resolutionGroup : groups) {
            this.performDownloads(session, resolutionGroup);
        }
        for (ArtifactResult artifactResult : results) {
            ArtifactRequest request = artifactResult.getRequest();
            Artifact artifact = artifactResult.getArtifact();
            if (artifact != null && artifact.getFile() != null) continue;
            failures = true;
            if (artifactResult.getExceptions().isEmpty()) {
                ArtifactNotFoundException exception = new ArtifactNotFoundException(request.getArtifact(), null);
                artifactResult.addException(exception);
            }
            RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
            this.artifactResolved(session, trace, request.getArtifact(), null, artifactResult.getExceptions());
        }
        if (failures) {
            throw new ArtifactResolutionException(results);
        }
        return results;
    }

    private boolean isLocallyInstalled(LocalArtifactResult lar, VersionResult vr) {
        if (lar.isAvailable()) {
            return true;
        }
        if (lar.getFile() != null) {
            if (vr.getRepository() instanceof LocalRepository) {
                return true;
            }
            if (vr.getRepository() == null && lar.getRequest().getRepositories().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private File getFile(RepositorySystemSession session, Artifact artifact, File file) throws ArtifactTransferException {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion()) && ConfigUtils.getBoolean(session, true, CONFIG_PROP_SNAPSHOT_NORMALIZATION)) {
            boolean copy;
            String name = file.getName().replace(artifact.getVersion(), artifact.getBaseVersion());
            File dst = new File(file.getParent(), name);
            boolean bl = copy = dst.length() != file.length() || dst.lastModified() != file.lastModified();
            if (copy) {
                try {
                    this.fileProcessor.copy(file, dst);
                    dst.setLastModified(file.lastModified());
                }
                catch (IOException e) {
                    throw new ArtifactTransferException(artifact, null, e);
                }
            }
            file = dst;
        }
        return file;
    }

    private void performDownloads(RepositorySystemSession session, ResolutionGroup group) {
        List<ArtifactDownload> downloads = this.gatherDownloads(session, group);
        if (downloads.isEmpty()) {
            return;
        }
        for (ArtifactDownload download : downloads) {
            this.artifactDownloading(session, download.getTrace(), download.getArtifact(), group.repository);
        }
        try {
            RepositoryConnector connector = this.repositoryConnectorProvider.newRepositoryConnector(session, group.repository);
            Object object = null;
            try {
                connector.get(downloads, null);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (connector != null) {
                    if (object != null) {
                        try {
                            connector.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        connector.close();
                    }
                }
            }
        }
        catch (NoRepositoryConnectorException e) {
            for (ArtifactDownload download : downloads) {
                download.setException(new ArtifactTransferException(download.getArtifact(), group.repository, e));
            }
        }
        this.evaluateDownloads(session, group);
    }

    private List<ArtifactDownload> gatherDownloads(RepositorySystemSession session, ResolutionGroup group) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        ArrayList<ArtifactDownload> downloads = new ArrayList<ArtifactDownload>();
        for (ResolutionItem item : group.items) {
            Artifact artifact = item.artifact;
            if (item.resolved.get()) continue;
            ArtifactDownload download = new ArtifactDownload();
            download.setArtifact(artifact);
            download.setRequestContext(item.request.getRequestContext());
            download.setListener(SafeTransferListener.wrap(session));
            download.setTrace(item.trace);
            if (item.local.getFile() != null) {
                download.setFile(item.local.getFile());
                download.setExistenceCheck(true);
            } else {
                String path = lrm.getPathForRemoteArtifact(artifact, group.repository, item.request.getRequestContext());
                download.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
            boolean snapshot = artifact.isSnapshot();
            RepositoryPolicy policy = this.remoteRepositoryManager.getPolicy(session, group.repository, !snapshot, snapshot);
            int errorPolicy = Utils.getPolicy(session, artifact, group.repository);
            if ((errorPolicy & 3) != 0) {
                UpdateCheck<Artifact, ArtifactTransferException> check = new UpdateCheck<Artifact, ArtifactTransferException>();
                check.setItem(artifact);
                check.setFile(download.getFile());
                check.setFileValid(false);
                check.setRepository(group.repository);
                check.setPolicy(policy.getUpdatePolicy());
                item.updateCheck = check;
                this.updateCheckManager.checkArtifact(session, check);
                if (!check.isRequired()) {
                    item.result.addException(check.getException());
                    continue;
                }
            }
            download.setChecksumPolicy(policy.getChecksumPolicy());
            download.setRepositories(item.repository.getMirroredRepositories());
            downloads.add(download);
            item.download = download;
        }
        return downloads;
    }

    private void evaluateDownloads(RepositorySystemSession session, ResolutionGroup group) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        for (ResolutionItem item : group.items) {
            ArtifactDownload download = item.download;
            if (download == null) continue;
            Artifact artifact = download.getArtifact();
            if (download.getException() == null) {
                item.resolved.set(true);
                item.result.setRepository(group.repository);
                try {
                    artifact = artifact.setFile(this.getFile(session, artifact, download.getFile()));
                    item.result.setArtifact(artifact);
                    lrm.add(session, new LocalArtifactRegistration(artifact, group.repository, download.getSupportedContexts()));
                }
                catch (ArtifactTransferException e) {
                    download.setException(e);
                    item.result.addException(e);
                }
            } else {
                item.result.addException(download.getException());
            }
            if (item.updateCheck != null) {
                item.updateCheck.setException(download.getException());
                this.updateCheckManager.touchArtifact(session, item.updateCheck);
            }
            this.artifactDownloaded(session, download.getTrace(), artifact, group.repository, download.getException());
            if (download.getException() != null) continue;
            this.artifactResolved(session, download.getTrace(), artifact, group.repository, null);
        }
    }

    private void artifactResolving(RepositorySystemSession session, RequestTrace trace, Artifact artifact) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactResolved(RepositorySystemSession session, RequestTrace trace, Artifact artifact, ArtifactRepository repository, List<Exception> exceptions) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_RESOLVED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setExceptions(exceptions);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloading(RepositorySystemSession session, RequestTrace trace, Artifact artifact, RemoteRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactDownloaded(RepositorySystemSession session, RequestTrace trace, Artifact artifact, RemoteRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(repository);
        event.setException(exception);
        if (artifact != null) {
            event.setFile(artifact.getFile());
        }
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    static class ResolutionItem {
        final RequestTrace trace;
        final ArtifactRequest request;
        final ArtifactResult result;
        final LocalArtifactResult local;
        final RemoteRepository repository;
        final Artifact artifact;
        final AtomicBoolean resolved;
        ArtifactDownload download;
        UpdateCheck<Artifact, ArtifactTransferException> updateCheck;

        ResolutionItem(RequestTrace trace, Artifact artifact, AtomicBoolean resolved, ArtifactResult result, LocalArtifactResult local, RemoteRepository repository) {
            this.trace = trace;
            this.artifact = artifact;
            this.resolved = resolved;
            this.result = result;
            this.request = result.getRequest();
            this.local = local;
            this.repository = repository;
        }
    }

    static class ResolutionGroup {
        final RemoteRepository repository;
        final List<ResolutionItem> items = new ArrayList<ResolutionItem>();

        ResolutionGroup(RemoteRepository repository) {
            this.repository = repository;
        }

        boolean matches(RemoteRepository repo) {
            return this.repository.getUrl().equals(repo.getUrl()) && this.repository.getContentType().equals(repo.getContentType()) && this.repository.isRepositoryManager() == repo.isRepositoryManager();
        }
    }
}

