/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import java.util.function.Supplier;
import org.springframework.boot.logging.logback.LogbackConfigurator;

class DebugLogbackConfigurator
extends LogbackConfigurator {
    DebugLogbackConfigurator(LoggerContext context) {
        super(context);
    }

    @Override
    <T extends Converter<?>> void conversionRule(String conversionWord, Class<T> converterClass, Supplier<T> converterSupplier) {
        this.info("Adding conversion rule of type '" + converterClass.getName() + "' for word '" + conversionWord + "'");
        super.conversionRule(conversionWord, converterClass, converterSupplier);
    }

    @Override
    void appender(String name, Appender<?> appender) {
        this.info("Adding appender '" + String.valueOf(appender) + "' named '" + name + "'");
        super.appender(name, appender);
    }

    @Override
    void logger(String name, Level level, boolean additive, Appender<ILoggingEvent> appender) {
        this.info("Configuring logger '" + name + "' with level '" + String.valueOf(level) + "'. Additive: " + additive);
        if (appender != null) {
            this.info("Adding appender '" + String.valueOf(appender) + "' to logger '" + name + "'");
        }
        super.logger(name, level, additive, appender);
    }

    @Override
    void start(LifeCycle lifeCycle) {
        this.info("Starting '" + String.valueOf(lifeCycle) + "'");
        super.start(lifeCycle);
    }

    private void info(String message) {
        this.getContext().getStatusManager().add((Status)new InfoStatus(message, (Object)this));
    }
}

