/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.r2dbc;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.PostgreSQLR2DBCDatabaseContainer;

class PostgresR2dbcContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<PostgreSQLContainer<?>, R2dbcConnectionDetails> {
    PostgresR2dbcContainerConnectionDetailsFactory() {
        super(ANY_CONNECTION_NAME, "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    public R2dbcConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<PostgreSQLContainer<?>> source) {
        return new PostgresR2dbcDatabaseContainerConnectionDetails(source);
    }

    private static final class PostgresR2dbcDatabaseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<PostgreSQLContainer<?>>
    implements R2dbcConnectionDetails {
        PostgresR2dbcDatabaseContainerConnectionDetails(ContainerConnectionSource<PostgreSQLContainer<?>> source) {
            super(source);
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return PostgreSQLR2DBCDatabaseContainer.getOptions((PostgreSQLContainer)((PostgreSQLContainer)this.getContainer()));
        }
    }
}

