/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.http.client;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.http.client.DisableReactorResourceFactoryGlobalResourcesBeanPostProcessor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ClassUtils;

class DisableReactorResourceFactoryGlobalResourcesContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final String REACTOR_RESOURCE_FACTORY_CLASS = "org.springframework.http.client.ReactorResourceFactory";
    private static final String REACTOR_NETTY_CLASS = "reactor.netty.ReactorNetty";

    DisableReactorResourceFactoryGlobalResourcesContextCustomizerFactory() {
    }

    public @Nullable ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ClassLoader classLoader = testClass.getClassLoader();
        if (ClassUtils.isPresent((String)REACTOR_RESOURCE_FACTORY_CLASS, (ClassLoader)classLoader) && ClassUtils.isPresent((String)REACTOR_NETTY_CLASS, (ClassLoader)classLoader)) {
            return new DisableReactorResourceFactoryGlobalResourcesContextCustomizerCustomizer();
        }
        return null;
    }

    static final class DisableReactorResourceFactoryGlobalResourcesContextCustomizerCustomizer
    implements ContextCustomizer {
        private DisableReactorResourceFactoryGlobalResourcesContextCustomizerCustomizer() {
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            context.getBeanFactory().registerSingleton(DisableReactorResourceFactoryGlobalResourcesBeanPostProcessor.class.getName(), (Object)new DisableReactorResourceFactoryGlobalResourcesBeanPostProcessor());
        }

        public boolean equals(Object obj) {
            return obj instanceof DisableReactorResourceFactoryGlobalResourcesContextCustomizerCustomizer;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

