/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.filter.annotation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class TypeIncludes
implements Iterable<Class<?>> {
    private static final String LOCATION = "META-INF/spring/%s.includes";
    private static final String COMMENT_START = "#";
    private final Set<Class<?>> includes;

    private TypeIncludes(Set<Class<?>> includes) {
        Assert.notNull(includes, (String)"'includes' must not be null");
        this.includes = Collections.unmodifiableSet(includes);
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.includes.iterator();
    }

    Set<Class<?>> getIncludes() {
        return this.includes;
    }

    static TypeIncludes load(Class<?> annotation, @Nullable ClassLoader classLoader) {
        Assert.notNull(annotation, (String)"'annotation' must not be null");
        ClassLoader classLoaderToUse = TypeIncludes.decideClassloader(classLoader);
        String location = String.format(LOCATION, annotation.getName());
        Enumeration<URL> urls = TypeIncludes.findUrlsInClasspath(classLoaderToUse, location);
        HashSet includes = new HashSet();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            includes.addAll(TypeIncludes.loadIncludes(url, classLoader));
        }
        return new TypeIncludes(includes);
    }

    private static ClassLoader decideClassloader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return TypeIncludes.class.getClassLoader();
        }
        return classLoader;
    }

    private static Enumeration<URL> findUrlsInClasspath(ClassLoader classLoader, String location) {
        try {
            return classLoader.getResources(location);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to load includes from location [" + location + "]", ex);
        }
    }

    private static Set<Class<?>> loadIncludes(URL url, @Nullable ClassLoader classLoader) {
        Set<String> includeNames = TypeIncludes.readIncludes(url);
        HashSet includes = new HashSet(includeNames.size());
        for (String includeName : includeNames) {
            try {
                includes.add(ClassUtils.forName((String)includeName, (ClassLoader)classLoader));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to load include '" + includeName + "' declared in " + String.valueOf(url));
            }
        }
        return includes;
    }

    private static Set<String> readIncludes(URL url) {
        HashSet<String> hashSet;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new UrlResource(url).getInputStream(), StandardCharsets.UTF_8));
        try {
            String line;
            HashSet<String> includes = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                line = TypeIncludes.stripComment(line);
                if ((line = line.trim()).isEmpty()) continue;
                includes.add(line);
            }
            hashSet = includes;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Unable to load includes from location [" + String.valueOf(url) + "]", ex);
            }
        }
        reader.close();
        return hashSet;
    }

    private static String stripComment(String line) {
        int commentStart = line.indexOf(COMMENT_START);
        if (commentStart == -1) {
            return line;
        }
        return line.substring(0, commentStart);
    }
}

