/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.dynatrace;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.dynatrace.DynatraceConfig;
import io.micrometer.dynatrace.DynatraceMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.dynatrace.DynatraceProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.dynatrace.DynatracePropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={DynatraceMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="dynatrace")
@EnableConfigurationProperties(value={DynatraceProperties.class})
public final class DynatraceMetricsExportAutoConfiguration {
    private final DynatraceProperties properties;

    DynatraceMetricsExportAutoConfiguration(DynatraceProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    DynatraceConfig dynatraceConfig() {
        return new DynatracePropertiesConfigAdapter(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    DynatraceMeterRegistry dynatraceMeterRegistry(DynatraceConfig dynatraceConfig, Clock clock) {
        return DynatraceMeterRegistry.builder((DynatraceConfig)dynatraceConfig).clock(clock).httpClient((HttpSender)new HttpUrlConnectionSender(this.properties.getConnectTimeout(), this.properties.getReadTimeout())).build();
    }
}

