/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.build.AbstractBuildLog;
import org.springframework.boot.buildpack.platform.build.BuildLog;
import org.springframework.boot.buildpack.platform.build.BuildRequest;
import org.springframework.boot.buildpack.platform.build.Builder;
import org.springframework.boot.buildpack.platform.build.BuilderDockerConfiguration;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.build.PullPolicy;
import org.springframework.boot.buildpack.platform.docker.TotalProgressEvent;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.ImagePackager;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.LoaderImplementation;
import org.springframework.boot.maven.AbstractPackagerMojo;
import org.springframework.boot.maven.Docker;
import org.springframework.boot.maven.Image;
import org.springframework.boot.maven.VersionExtractor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class BuildImageMojo
extends AbstractPackagerMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    private String finalName;
    @Parameter(property="spring-boot.build-image.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private @Nullable String classifier;
    @Parameter
    private @Nullable Image image;
    @Parameter(property="spring-boot.build-image.imageName")
    @Nullable String imageName;
    @Parameter(property="spring-boot.build-image.builder")
    @Nullable String imageBuilder;
    @Parameter(property="spring-boot.build-image.trustBuilder")
    @Nullable Boolean trustBuilder;
    @Parameter(property="spring-boot.build-image.runImage")
    @Nullable String runImage;
    @Parameter(property="spring-boot.build-image.cleanCache")
    @Nullable Boolean cleanCache;
    @Parameter(property="spring-boot.build-image.pullPolicy")
    @Nullable PullPolicy pullPolicy;
    @Parameter(property="spring-boot.build-image.publish")
    @Nullable Boolean publish;
    @Parameter(property="spring-boot.build-image.network")
    @Nullable String network;
    @Parameter(property="spring-boot.build-image.createdDate")
    @Nullable String createdDate;
    @Parameter(property="spring-boot.build-image.applicationDirectory")
    @Nullable String applicationDirectory;
    @Parameter(property="spring-boot.build-image.imagePlatform")
    @Nullable String imagePlatform;
    @Parameter
    private @Nullable Docker docker;
    @Parameter
    private @Nullable AbstractPackagerMojo.LayoutType layout;
    @Parameter
    private @Nullable LoaderImplementation loaderImplementation;
    @Parameter
    private @Nullable LayoutFactory layoutFactory;

    protected BuildImageMojo(MavenProjectHelper projectHelper) {
        super(projectHelper);
    }

    @Override
    protected @Nullable AbstractPackagerMojo.LayoutType getLayout() {
        return this.layout;
    }

    @Override
    protected @Nullable LoaderImplementation getLoaderImplementation() {
        return this.loaderImplementation;
    }

    @Override
    protected @Nullable LayoutFactory getLayoutFactory() {
        return this.layoutFactory;
    }

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"build-image goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping build-image as per configuration.");
            return;
        }
        this.buildImage();
    }

    private void buildImage() throws MojoExecutionException {
        Libraries libraries = this.getLibraries(Collections.emptySet());
        try {
            BuildRequest request = this.getBuildRequest(libraries);
            Docker docker = this.docker != null ? this.docker : new Docker();
            BuilderDockerConfiguration dockerConfiguration = docker.asDockerConfiguration(this.getLog(), request.isPublish());
            Builder builder = new Builder((BuildLog)new MojoBuildLog(() -> ((BuildImageMojo)this).getLog()), dockerConfiguration);
            builder.build(request);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private BuildRequest getBuildRequest(Libraries libraries) {
        Image image;
        ImagePackager imagePackager = new ImagePackager(this.getArchiveFile(), this.getBackupFile());
        Function<Owner, TarArchive> content = owner -> this.getApplicationContent((Owner)owner, libraries, imagePackager);
        Image image2 = image = this.image != null ? this.image : new Image();
        if (image.name == null && this.imageName != null) {
            image.setName(this.imageName);
        }
        if (image.builder == null && this.imageBuilder != null) {
            image.setBuilder(this.imageBuilder);
        }
        if (image.trustBuilder == null && this.trustBuilder != null) {
            image.setTrustBuilder(this.trustBuilder);
        }
        if (image.runImage == null && this.runImage != null) {
            image.setRunImage(this.runImage);
        }
        if (image.cleanCache == null && this.cleanCache != null) {
            image.setCleanCache(this.cleanCache);
        }
        if (image.pullPolicy == null && this.pullPolicy != null) {
            image.setPullPolicy(this.pullPolicy);
        }
        if (image.publish == null && this.publish != null) {
            image.setPublish(this.publish);
        }
        if (image.network == null && this.network != null) {
            image.setNetwork(this.network);
        }
        if (image.createdDate == null && this.createdDate != null) {
            image.setCreatedDate(this.createdDate);
        }
        if (image.applicationDirectory == null && this.applicationDirectory != null) {
            image.setApplicationDirectory(this.applicationDirectory);
        }
        if (image.imagePlatform == null && this.imagePlatform != null) {
            image.setImagePlatform(this.imagePlatform);
        }
        return this.customize(image.getBuildRequest(this.project.getArtifact(), content));
    }

    private TarArchive getApplicationContent(Owner owner, Libraries libraries, ImagePackager imagePackager) {
        ImagePackager packager = this.getConfiguredPackager(() -> imagePackager);
        return new PackagedTarArchive(owner, libraries, packager);
    }

    private File getArchiveFile() {
        File archiveFile = this.getTargetFile(this.finalName, this.classifier, this.sourceDirectory);
        if (!archiveFile.exists()) {
            archiveFile = this.getSourceArtifact(this.classifier).getFile();
        }
        if (!archiveFile.exists()) {
            throw new IllegalStateException("A jar or war file is required for building image");
        }
        return archiveFile;
    }

    private @Nullable File getBackupFile() {
        if (this.classifier != null) {
            File backupFile = this.getTargetFile(this.finalName, null, this.sourceDirectory);
            if (backupFile.exists()) {
                return backupFile;
            }
            Artifact source = this.getSourceArtifact(null);
            if (!this.classifier.equals(source.getClassifier())) {
                return source.getFile();
            }
        }
        return null;
    }

    private BuildRequest customize(BuildRequest request) {
        request = this.customizeCreator(request);
        return request;
    }

    private BuildRequest customizeCreator(BuildRequest request) {
        String springBootVersion = VersionExtractor.forClass(BuildImageMojo.class);
        if (StringUtils.hasText((String)springBootVersion)) {
            request = request.withCreator(Creator.withVersion((String)springBootVersion));
        }
        return request;
    }

    static {
        System.setProperty("org.slf4j.simpleLogger.log.org.apache.http.wire", "ERROR");
    }

    private static class MojoBuildLog
    extends AbstractBuildLog {
        private static final long THRESHOLD = Duration.ofSeconds(2L).toMillis();
        private final Supplier<Log> log;

        MojoBuildLog(Supplier<Log> log) {
            this.log = log;
        }

        protected void log(String message) {
            this.log.get().info((CharSequence)message);
        }

        protected Consumer<TotalProgressEvent> getProgressConsumer(String message) {
            return new ProgressLog(message);
        }

        private class ProgressLog
        implements Consumer<TotalProgressEvent> {
            private final String message;
            private long last;

            ProgressLog(String message) {
                this.message = message;
                this.last = System.currentTimeMillis();
            }

            @Override
            public void accept(TotalProgressEvent progress) {
                this.log(progress.getPercent());
            }

            private void log(int percent) {
                if (percent == 100 || System.currentTimeMillis() - this.last > THRESHOLD) {
                    MojoBuildLog.this.log.get().info((CharSequence)(this.message + " " + percent + "%"));
                    this.last = System.currentTimeMillis();
                }
            }
        }
    }

    static class PackagedTarArchive
    implements TarArchive {
        static final long NORMALIZED_MOD_TIME = TarArchive.NORMALIZED_TIME.toEpochMilli();
        private final Owner owner;
        private final Libraries libraries;
        private final ImagePackager packager;

        PackagedTarArchive(Owner owner, Libraries libraries, ImagePackager packager) {
            this.owner = owner;
            this.libraries = libraries;
            this.packager = packager;
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            TarArchiveOutputStream tar = new TarArchiveOutputStream(outputStream);
            tar.setLongFileMode(3);
            try {
                this.packager.packageImage(this.libraries, (entry, entryWriter) -> this.write((ZipEntry)entry, (EntryWriter)entryWriter, tar));
            }
            catch (RuntimeException ex) {
                outputStream.close();
                throw new RuntimeException("Error packaging archive for image", ex);
            }
        }

        private void write(ZipEntry jarEntry, @Nullable EntryWriter entryWriter, TarArchiveOutputStream tar) {
            try {
                TarArchiveEntry tarEntry = this.convert(jarEntry);
                tar.putArchiveEntry(tarEntry);
                if (tarEntry.isFile()) {
                    Assert.state((entryWriter != null ? 1 : 0) != 0, (String)"'entryWriter' must not be null");
                    entryWriter.write((OutputStream)tar);
                }
                tar.closeArchiveEntry();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private TarArchiveEntry convert(ZipEntry entry) {
            byte linkFlag = entry.isDirectory() ? (byte)53 : 48;
            TarArchiveEntry tarEntry = new TarArchiveEntry(entry.getName(), linkFlag, true);
            tarEntry.setUserId(this.owner.getUid());
            tarEntry.setGroupId(this.owner.getGid());
            tarEntry.setModTime(NORMALIZED_MOD_TIME);
            if (!entry.isDirectory()) {
                tarEntry.setSize(entry.getSize());
            }
            return tarEntry;
        }
    }
}

