/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import jakarta.json.bind.Jsonb;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.http.converter.autoconfigure.ClientHttpMessageConvertersCustomizer;
import org.springframework.boot.http.converter.autoconfigure.GsonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.Jackson2HttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.JacksonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Jsonb.class})
class JsonbHttpMessageConvertersConfiguration {
    JsonbHttpMessageConvertersConfiguration() {
    }

    private static class PreferJsonbOrMissingJacksonAndGsonCondition
    extends AnyNestedCondition {
        PreferJsonbOrMissingJacksonAndGsonCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={JacksonHttpMessageConvertersConfiguration.JacksonJsonHttpMessageConvertersCustomizer.class, Jackson2HttpMessageConvertersConfiguration.Jackson2JsonMessageConvertersCustomizer.class, GsonHttpMessageConvertersConfiguration.GsonHttpConvertersCustomizer.class})
        static class JacksonAndGsonMissing {
            JacksonAndGsonMissing() {
            }
        }

        @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="jsonb")
        static class JsonbPreferred {
            JsonbPreferred() {
            }
        }
    }

    static class JsonbHttpMessageConvertersCustomizer
    implements ClientHttpMessageConvertersCustomizer,
    ServerHttpMessageConvertersCustomizer {
        private final JsonbHttpMessageConverter converter;

        JsonbHttpMessageConvertersCustomizer(Jsonb jsonb) {
            this.converter = new JsonbHttpMessageConverter(jsonb);
        }

        @Override
        public void customize(HttpMessageConverters.ClientBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)this.converter);
        }

        @Override
        public void customize(HttpMessageConverters.ServerBuilder builder) {
            builder.withJsonConverter((HttpMessageConverter)this.converter);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Jsonb.class})
    @Conditional(value={PreferJsonbOrMissingJacksonAndGsonCondition.class})
    static class JsonbHttpMessageConverterConfiguration {
        JsonbHttpMessageConverterConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnMissingBean(value={JsonbHttpMessageConverter.class})
        JsonbHttpMessageConvertersCustomizer jsonbHttpMessageConvertersCustomizer(Jsonb jsonb) {
            return new JsonbHttpMessageConvertersCustomizer(jsonb);
        }
    }
}

