/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.converter.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.converter.autoconfigure.GsonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConvertersProperties;
import org.springframework.boot.http.converter.autoconfigure.JacksonHttpMessageConvertersConfiguration;
import org.springframework.boot.http.converter.autoconfigure.JsonbHttpMessageConvertersConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration", "org.springframework.boot.jsonb.autoconfigure.JsonbAutoConfiguration", "org.springframework.boot.gson.autoconfigure.GsonAutoConfiguration"})
@ConditionalOnClass(value={HttpMessageConverter.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@Import(value={JacksonHttpMessageConvertersConfiguration.class, GsonHttpMessageConvertersConfiguration.class, JsonbHttpMessageConvertersConfiguration.class})
public final class HttpMessageConvertersAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";

    @Bean
    @ConditionalOnMissingBean
    HttpMessageConverters messageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new HttpMessageConverters(converters.orderedStream().toList());
    }

    static class NotReactiveWebApplicationCondition
    extends NoneNestedConditions {
        NotReactiveWebApplicationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        private static final class ReactiveWebApplication {
            private ReactiveWebApplication() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={StringHttpMessageConverter.class})
    @EnableConfigurationProperties(value={HttpMessageConvertersProperties.class})
    protected static class StringHttpMessageConverterConfiguration {
        protected StringHttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        StringHttpMessageConverter stringHttpMessageConverter(HttpMessageConvertersProperties properties) {
            StringHttpMessageConverter converter = new StringHttpMessageConverter(properties.getStringEncodingCharset());
            converter.setWriteAcceptCharset(false);
            return converter;
        }
    }
}

