/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.springframework.boot.loader.tools.LibraryCoordinates;

class ResolvedDependencies {
    private final Map<String, LibraryCoordinates> projectCoordinatesByPath;
    private final ListProperty<ComponentArtifactIdentifier> artifactIds;
    private final ListProperty<File> artifactFiles;

    ResolvedDependencies(Project project) {
        this.artifactIds = project.getObjects().listProperty(ComponentArtifactIdentifier.class);
        this.artifactFiles = project.getObjects().listProperty(File.class);
        this.projectCoordinatesByPath = ResolvedDependencies.projectCoordinatesByPath(project);
    }

    private static Map<String, LibraryCoordinates> projectCoordinatesByPath(Project project) {
        return project.getRootProject().getAllprojects().stream().collect(Collectors.toMap(Project::getPath, ResolvedDependencies::libraryCoordinates));
    }

    private static LibraryCoordinates libraryCoordinates(Project project) {
        return LibraryCoordinates.of((String)Objects.toString(project.getGroup()), (String)project.getName(), (String)Objects.toString(project.getVersion()));
    }

    @Input
    ListProperty<ComponentArtifactIdentifier> getArtifactIds() {
        return this.artifactIds;
    }

    @Classpath
    ListProperty<File> getArtifactFiles() {
        return this.artifactFiles;
    }

    void resolvedArtifacts(Provider<Set<ResolvedArtifactResult>> resolvedArtifacts) {
        this.artifactFiles.addAll(resolvedArtifacts.map(artifacts -> artifacts.stream().map(ResolvedArtifactResult::getFile).toList()));
        this.artifactIds.addAll(resolvedArtifacts.map(artifacts -> artifacts.stream().map(ArtifactResult::getId).toList()));
    }

    DependencyDescriptor find(File file) {
        ProjectComponentIdentifier projectComponentId;
        String projectPath;
        LibraryCoordinates projectCoordinates;
        ComponentArtifactIdentifier id = this.findArtifactIdentifier(file);
        if (id == null) {
            return null;
        }
        if (id instanceof ModuleComponentArtifactIdentifier) {
            ModuleComponentArtifactIdentifier moduleComponentId = (ModuleComponentArtifactIdentifier)id;
            ModuleComponentIdentifier moduleId = moduleComponentId.getComponentIdentifier();
            return new DependencyDescriptor(LibraryCoordinates.of((String)moduleId.getGroup(), (String)moduleId.getModule(), (String)moduleId.getVersion()), false);
        }
        ComponentIdentifier componentIdentifier = id.getComponentIdentifier();
        if (componentIdentifier instanceof ProjectComponentIdentifier && (projectCoordinates = this.projectCoordinatesByPath.get(projectPath = (projectComponentId = (ProjectComponentIdentifier)componentIdentifier).getProjectPath())) != null) {
            return new DependencyDescriptor(projectCoordinates, true);
        }
        return null;
    }

    private ComponentArtifactIdentifier findArtifactIdentifier(File file) {
        List files = (List)this.artifactFiles.get();
        for (int i = 0; i < files.size(); ++i) {
            if (!file.equals(files.get(i))) continue;
            return (ComponentArtifactIdentifier)((List)this.artifactIds.get()).get(i);
        }
        return null;
    }

    static final class DependencyDescriptor {
        private final LibraryCoordinates coordinates;
        private final boolean projectDependency;

        private DependencyDescriptor(LibraryCoordinates coordinates, boolean projectDependency) {
            this.coordinates = coordinates;
            this.projectDependency = projectDependency;
        }

        LibraryCoordinates getCoordinates() {
            return this.coordinates;
        }

        boolean isProjectDependency() {
            return this.projectDependency;
        }
    }
}

