/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;
import org.springframework.boot.gradle.plugin.JarTypeFileSpec;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.ResolveMainClassName;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.tasks.bundling.BootBuildImage;
import org.springframework.boot.gradle.tasks.bundling.BootWar;

class WarPluginAction
implements PluginApplicationAction {
    private final SinglePublishedArtifact singlePublishedArtifact;

    WarPluginAction(SinglePublishedArtifact singlePublishedArtifact) {
        this.singlePublishedArtifact = singlePublishedArtifact;
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return WarPlugin.class;
    }

    public void execute(Project project) {
        this.classifyWarTask(project);
        TaskProvider<BootWar> bootWar = this.configureBootWarTask(project);
        this.configureBootBuildImageTask(project, bootWar);
        this.configureArtifactPublication(bootWar);
    }

    private void classifyWarTask(Project project) {
        project.getTasks().named("war", War.class).configure(war -> war.getArchiveClassifier().convention((Object)"plain"));
    }

    private TaskProvider<BootWar> configureBootWarTask(Project project) {
        Configuration developmentOnly = project.getConfigurations().getByName("developmentOnly");
        Configuration productionRuntimeClasspath = project.getConfigurations().getByName("productionRuntimeClasspath");
        SourceSet mainSourceSet = (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main");
        Configuration runtimeClasspath = project.getConfigurations().getByName(mainSourceSet.getRuntimeClasspathConfigurationName());
        Callable<FileCollection> classpath = () -> mainSourceSet.getRuntimeClasspath().minus(this.providedRuntimeConfiguration(project)).minus(developmentOnly.minus((FileCollection)productionRuntimeClasspath)).filter((Spec)new JarTypeFileSpec());
        TaskProvider resolveMainClassName = project.getTasks().named("resolveMainClassName", ResolveMainClassName.class);
        TaskProvider bootWarProvider = project.getTasks().register("bootWar", BootWar.class, bootWar -> {
            bootWar.setGroup("build");
            bootWar.setDescription("Assembles an executable war archive containing webapp content, and the main classes and their dependencies.");
            bootWar.providedClasspath(this.providedRuntimeConfiguration(project));
            bootWar.setClasspath(classpath);
            Provider manifestStartClass = project.provider(() -> (String)bootWar.getManifest().getAttributes().get((Object)"Start-Class"));
            bootWar.getMainClass().convention(resolveMainClassName.flatMap(resolver -> manifestStartClass.isPresent() ? manifestStartClass : resolver.readMainClassName()));
            bootWar.getTargetJavaVersion().set(project.provider(() -> this.javaPluginExtension(project).getTargetCompatibility()));
            bootWar.resolvedArtifacts((Provider<Set<ResolvedArtifactResult>>)runtimeClasspath.getIncoming().getArtifacts().getResolvedArtifacts());
        });
        bootWarProvider.map(War::getClasspath);
        return bootWarProvider;
    }

    private FileCollection providedRuntimeConfiguration(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        return configurations.getByName("providedRuntime");
    }

    private void configureBootBuildImageTask(Project project, TaskProvider<BootWar> bootWar) {
        project.getTasks().named("bootBuildImage", BootBuildImage.class).configure(buildImage -> buildImage.getArchiveFile().set(((BootWar)bootWar.get()).getArchiveFile()));
    }

    private void configureArtifactPublication(TaskProvider<BootWar> bootWar) {
        this.singlePublishedArtifact.addWarCandidate(bootWar);
    }

    private JavaPluginExtension javaPluginExtension(Project project) {
        return (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
    }
}

