/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.mariadb;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.mariadb.MariaDbEnvironment;
import org.springframework.boot.docker.compose.service.connection.r2dbc.ConnectionFactoryOptionsBuilder;

class MariaDbR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    private static final String[] MARIADB_CONTAINER_NAMES = new String[]{"mariadb", "bitnami/mariadb", "bitnamilegacy/mariadb"};

    MariaDbR2dbcDockerComposeConnectionDetailsFactory() {
        super(MARIADB_CONTAINER_NAMES, "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new MariaDbR2dbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class MariaDbR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("mariadb", 3306);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        MariaDbR2dbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            MariaDbEnvironment environment = new MariaDbEnvironment(service.env());
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, environment.getDatabase(), environment.getUsername(), environment.getPassword());
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

