/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.boot.docker.compose.core.ImageReference;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.util.Assert;

class ConnectionNamePredicate
implements Predicate<DockerComposeConnectionSource> {
    private final Set<String> required;

    ConnectionNamePredicate(String ... required) {
        Assert.notEmpty((Object[])required, (String)"'required' must not be empty");
        this.required = Arrays.stream(required).map(this::asCanonicalName).collect(Collectors.toSet());
    }

    @Override
    public boolean test(DockerComposeConnectionSource source) {
        String actual = this.getActual(source.getRunningService());
        return this.required.contains(actual);
    }

    private String getActual(RunningService service) {
        String label = service.labels().get("org.springframework.boot.service-connection");
        return label != null ? this.asCanonicalName(label) : service.image().getName();
    }

    private String asCanonicalName(String name) {
        return ImageReference.of(name).getName();
    }
}

