/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client.reactive;

import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.client.ConditionalOnOAuth2ClientRegistrationProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesMapper;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;

class ReactiveOAuth2ClientConfigurations {
    ReactiveOAuth2ClientConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ReactiveClientRegistrationRepository.class})
    static class ReactiveOAuth2AuthorizedClientServiceConfiguration {
        ReactiveOAuth2AuthorizedClientServiceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ReactiveOAuth2AuthorizedClientService reactiveAuthorizedClientService(ReactiveClientRegistrationRepository clientRegistrationRepository) {
            return new InMemoryReactiveOAuth2AuthorizedClientService(clientRegistrationRepository);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={OAuth2ClientProperties.class})
    @ConditionalOnOAuth2ClientRegistrationProperties
    @ConditionalOnMissingBean(value={ReactiveClientRegistrationRepository.class})
    static class ReactiveClientRegistrationRepositoryConfiguration {
        ReactiveClientRegistrationRepositoryConfiguration() {
        }

        @Bean
        InMemoryReactiveClientRegistrationRepository reactiveClientRegistrationRepository(OAuth2ClientProperties properties) {
            ArrayList<ClientRegistration> registrations = new ArrayList<ClientRegistration>(new OAuth2ClientPropertiesMapper(properties).asClientRegistrations().values());
            return new InMemoryReactiveClientRegistrationRepository(registrations);
        }
    }
}

