/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.AbstractCursorItemReader;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class JdbcCursorItemReader<T>
extends AbstractCursorItemReader<T> {
    private @Nullable PreparedStatement preparedStatement;
    private @Nullable PreparedStatementSetter preparedStatementSetter;
    private String sql;
    private RowMapper<T> rowMapper;

    public JdbcCursorItemReader(DataSource dataSource, String sql, RowMapper<T> rowMapper) {
        super(dataSource);
        Assert.notNull((Object)sql, (String)"The SQL query must not be null");
        Assert.notNull(rowMapper, (String)"RowMapper must not be null");
        this.sql = sql;
        this.rowMapper = rowMapper;
    }

    public void setRowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setPreparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    @Override
    protected void openCursor(Connection con) {
        try {
            this.preparedStatement = this.isUseSharedExtendedConnection() ? con.prepareStatement(this.sql, 1003, 1007, 1) : con.prepareStatement(this.sql, 1003, 1007);
            this.applyStatementSettings(this.preparedStatement);
            if (this.preparedStatementSetter != null) {
                this.preparedStatementSetter.setValues(this.preparedStatement);
            }
            this.rs = this.preparedStatement.executeQuery();
            this.handleWarnings(this.preparedStatement);
        }
        catch (SQLException se) {
            this.close();
            throw this.translateSqlException("Executing query", this.getSql(), se);
        }
    }

    @Override
    protected @Nullable T readCursor(ResultSet rs, int currentRow) throws SQLException {
        return (T)this.rowMapper.mapRow(rs, currentRow);
    }

    @Override
    protected void cleanupOnClose(Connection connection) {
        JdbcUtils.closeStatement((Statement)this.preparedStatement);
    }

    @Override
    public String getSql() {
        return Objects.requireNonNull(this.sql);
    }
}

