/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.support;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.ClassUtils;

public class DefaultPropertyEditorRegistrar
implements PropertyEditorRegistrar {
    private final Map<Class<?>, PropertyEditor> customEditors = new HashMap();

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        for (Map.Entry<Class<?>, PropertyEditor> entry : this.customEditors.entrySet()) {
            registry.registerCustomEditor(entry.getKey(), entry.getValue());
        }
    }

    public void setCustomEditors(Map<?, ? extends PropertyEditor> customEditors) {
        for (Map.Entry<?, PropertyEditor> entry : customEditors.entrySet()) {
            Class requiredType;
            Object key = entry.getKey();
            if (key instanceof Class) {
                requiredType = (Class)key;
            } else if (key instanceof String) {
                String className = (String)key;
                requiredType = ClassUtils.resolveClassName((String)className, (ClassLoader)this.getClass().getClassLoader());
            } else {
                throw new IllegalArgumentException("Invalid key [" + String.valueOf(key) + "] for custom editor: needs to be Class or String.");
            }
            PropertyEditor value = entry.getValue();
            this.customEditors.put(requiredType, value);
        }
    }
}

