/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.net.URI;
import java.util.Map;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    protected String webJarsPrefixUrl;

    public SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.webJarsPrefixUrl = springDocConfigProperties.getWebjars().getPrefix();
    }

    protected Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        this.buildFromCurrentContextPath(request);
        String sbUrl = this.buildUrl(this.contextPath, this.swaggerUiConfigParameters.getUiRootPath() + this.springDocConfigProperties.getWebjars().getPrefix() + this.getSwaggerUiUrl());
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(sbUrl);
        response.setStatusCode(HttpStatus.FOUND);
        response.getHeaders().setLocation(URI.create(uriBuilder.build().encode().toString()));
        return response.setComplete();
    }

    protected Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        this.buildFromCurrentContextPath(request);
        return this.swaggerUiConfigParameters.getConfigParameters();
    }

    void buildFromCurrentContextPath(ServerHttpRequest request) {
        super.init();
        this.contextPath = request.getPath().contextPath().value();
        String url = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).toUriString();
        if (!"/".equals(request.getPath().toString())) {
            url = url.replace(request.getPath().toString(), "");
        }
        this.buildConfigUrl(UriComponentsBuilder.fromUriString((String)url));
    }
}

