/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.security;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import org.springdoc.security.SpringDocSecurityOAuth2EndpointUtils;
import org.springdoc.security.oauth2.SpringDocOAuth2AuthorizationServerMetadata;
import org.springdoc.security.oauth2.SpringDocOAuth2Token;
import org.springdoc.security.oauth2.SpringDocOAuth2TokenIntrospection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.web.NimbusJwkSetEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationServerMetadataEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenIntrospectionEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2TokenRevocationEndpointFilter;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class SpringDocSecurityOAuth2Customizer
implements GlobalOpenApiCustomizer,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDocSecurityOAuth2Customizer.class);
    private static final String OAUTH2_ENDPOINT_TAG = "authorization-server-endpoints";
    private ApplicationContext applicationContext;

    public void customise(OpenAPI openAPI) {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.applicationContext.getBean("springSecurityFilterChain", FilterChainProxy.class);
        for (SecurityFilterChain filterChain : filterChainProxy.getFilterChains()) {
            this.getNimbusJwkSetEndpoint(openAPI, filterChain);
            this.getOAuth2AuthorizationServerMetadataEndpoint(openAPI, filterChain);
            this.getOAuth2TokenEndpoint(openAPI, filterChain);
            this.getOAuth2AuthorizationEndpoint(openAPI, filterChain);
            this.getOAuth2TokenIntrospectionEndpointFilter(openAPI, filterChain);
            this.getOAuth2TokenRevocationEndpointFilter(openAPI, filterChain);
        }
    }

    private void getOAuth2TokenRevocationEndpointFilter(OpenAPI openAPI, SecurityFilterChain securityFilterChain) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2TokenRevocationEndpointFilter>>(OAuth2TokenRevocationEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), new ApiResponse().description(HttpStatus.OK.getReasonPhrase()));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI);
            Operation operation = this.buildOperation(apiResponses);
            Schema schema = new ObjectSchema().addProperty("token", (Schema)new StringSchema()).addProperty("token_type_hint", (Schema)new StringSchema());
            String mediaType = "application/x-www-form-urlencoded";
            RequestBody requestBody = new RequestBody().content(new Content().addMediaType(mediaType, new MediaType().schema(schema)));
            operation.setRequestBody(requestBody);
            this.buildPath(oAuth2EndpointFilter, "tokenRevocationEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private void getOAuth2TokenIntrospectionEndpointFilter(OpenAPI openAPI, SecurityFilterChain securityFilterChain) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2TokenIntrospectionEndpointFilter>>(OAuth2TokenIntrospectionEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnSuccess(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOAuth2TokenIntrospection.class, (Components)openAPI.getComponents(), null));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI);
            Operation operation = this.buildOperation(apiResponses);
            Schema requestSchema = new ObjectSchema().addProperty("token", (Schema)new StringSchema()).addProperty("token_type_hint", (Schema)new StringSchema()).addProperty("additionalParameters", new ObjectSchema().additionalProperties((Object)new StringSchema()));
            String mediaType = "application/x-www-form-urlencoded";
            RequestBody requestBody = new RequestBody().content(new Content().addMediaType(mediaType, new MediaType().schema(requestSchema)));
            operation.setRequestBody(requestBody);
            this.buildPath(oAuth2EndpointFilter, "tokenIntrospectionEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private void getOAuth2AuthorizationServerMetadataEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2AuthorizationServerMetadataEndpointFilter>>(OAuth2AuthorizationServerMetadataEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnSuccess(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOAuth2AuthorizationServerMetadata.class, (Components)openAPI.getComponents(), null));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            Operation operation = this.buildOperation(apiResponses);
            this.buildPath(oAuth2EndpointFilter, "requestMatcher", openAPI, operation, HttpMethod.GET);
        }
    }

    private void getNimbusJwkSetEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<NimbusJwkSetEndpointFilter>>(NimbusJwkSetEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            MapSchema schema = new MapSchema();
            schema.addProperty("keys", (Schema)new ArraySchema().items(new ObjectSchema().additionalProperties((Object)true)));
            ApiResponse response = new ApiResponse().description(HttpStatus.OK.getReasonPhrase()).content(new Content().addMediaType("application/json", new MediaType().schema((Schema)schema)));
            apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), response);
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI);
            Operation operation = this.buildOperation(apiResponses);
            operation.responses(apiResponses);
            this.buildPath(oAuth2EndpointFilter, "requestMatcher", openAPI, operation, HttpMethod.GET);
        }
    }

    private void getOAuth2TokenEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2TokenEndpointFilter>>(OAuth2TokenEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            this.buildApiResponsesOnSuccess(apiResponses, AnnotationsUtils.resolveSchemaFromType(SpringDocOAuth2Token.class, (Components)openAPI.getComponents(), null));
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI);
            SpringDocSecurityOAuth2Customizer.buildOAuth2Error(openAPI, apiResponses, HttpStatus.UNAUTHORIZED);
            Operation operation = this.buildOperation(apiResponses);
            Schema requestSchema = new ObjectSchema().addProperty("grant_type", (Schema)new StringSchema().addEnumItem(AuthorizationGrantType.AUTHORIZATION_CODE.getValue()).addEnumItem(AuthorizationGrantType.REFRESH_TOKEN.getValue()).addEnumItem(AuthorizationGrantType.CLIENT_CREDENTIALS.getValue())).addProperty("code", (Schema)new StringSchema()).addProperty("redirect_uri", (Schema)new StringSchema()).addProperty("refresh_token", (Schema)new StringSchema()).addProperty("scope", (Schema)new StringSchema()).addProperty("client_id", (Schema)new StringSchema()).addProperty("client_secret", (Schema)new StringSchema()).addProperty("client_assertion_type", (Schema)new StringSchema()).addProperty("client_assertion", (Schema)new StringSchema()).addProperty("additionalParameters", new ObjectSchema().additionalProperties((Object)new StringSchema()));
            String mediaType = "application/x-www-form-urlencoded";
            RequestBody requestBody = new RequestBody().content(new Content().addMediaType(mediaType, new MediaType().schema(requestSchema)));
            operation.setRequestBody(requestBody);
            operation.addParametersItem(new HeaderParameter().name("Authorization"));
            this.buildPath(oAuth2EndpointFilter, "tokenEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private void getOAuth2AuthorizationEndpoint(OpenAPI openAPI, SecurityFilterChain securityFilterChain) {
        Object oAuth2EndpointFilter = new SpringDocSecurityOAuth2EndpointUtils<Class<OAuth2AuthorizationEndpointFilter>>(OAuth2AuthorizationEndpointFilter.class).findEndpoint(securityFilterChain);
        if (oAuth2EndpointFilter != null) {
            ApiResponses apiResponses = new ApiResponses();
            ApiResponse response = new ApiResponse().description(HttpStatus.OK.getReasonPhrase()).content(new Content().addMediaType("text/html", new MediaType()));
            apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), response);
            this.buildApiResponsesOnInternalServerError(apiResponses);
            this.buildApiResponsesOnBadRequest(apiResponses, openAPI);
            apiResponses.addApiResponse(String.valueOf(HttpStatus.MOVED_TEMPORARILY.value()), new ApiResponse().description(HttpStatus.MOVED_TEMPORARILY.getReasonPhrase()).addHeaderObject("Location", new Header().schema((Schema)new StringSchema())));
            Operation operation = this.buildOperation(apiResponses);
            Schema schema = new ObjectSchema().additionalProperties((Object)new StringSchema());
            operation.addParametersItem(new Parameter().name("parameters").in(ParameterIn.QUERY.toString()).schema(schema));
            this.buildPath(oAuth2EndpointFilter, "authorizationEndpointMatcher", openAPI, operation, HttpMethod.POST);
        }
    }

    private Operation buildOperation(ApiResponses apiResponses) {
        Operation operation = new Operation();
        operation.addTagsItem(OAUTH2_ENDPOINT_TAG);
        operation.responses(apiResponses);
        return operation;
    }

    private ApiResponses buildApiResponsesOnSuccess(ApiResponses apiResponses, Schema schema) {
        ApiResponse response = new ApiResponse().description(HttpStatus.OK.getReasonPhrase()).content(new Content().addMediaType("application/json", new MediaType().schema(schema)));
        apiResponses.addApiResponse(String.valueOf(HttpStatus.OK.value()), response);
        return apiResponses;
    }

    private ApiResponses buildApiResponsesOnInternalServerError(ApiResponses apiResponses) {
        apiResponses.addApiResponse(String.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), new ApiResponse().description(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        return apiResponses;
    }

    private ApiResponses buildApiResponsesOnBadRequest(ApiResponses apiResponses, OpenAPI openAPI) {
        SpringDocSecurityOAuth2Customizer.buildOAuth2Error(openAPI, apiResponses, HttpStatus.BAD_REQUEST);
        return apiResponses;
    }

    private static void buildOAuth2Error(OpenAPI openAPI, ApiResponses apiResponses, HttpStatus httpStatus) {
        Schema oAuth2ErrorSchema = AnnotationsUtils.resolveSchemaFromType(OAuth2Error.class, (Components)openAPI.getComponents(), null);
        apiResponses.addApiResponse(String.valueOf(httpStatus.value()), new ApiResponse().description(httpStatus.getReasonPhrase()).content(new Content().addMediaType("application/json", new MediaType().schema(oAuth2ErrorSchema))));
    }

    private void buildPath(Object oAuth2EndpointFilter, String authorizationEndpointMatcher, OpenAPI openAPI, Operation operation, HttpMethod requestMethod) {
        try {
            Field tokenEndpointMatcherField = FieldUtils.getDeclaredField(oAuth2EndpointFilter.getClass(), (String)authorizationEndpointMatcher, (boolean)true);
            RequestMatcher endpointMatcher = (RequestMatcher)tokenEndpointMatcherField.get(oAuth2EndpointFilter);
            String path = null;
            if (endpointMatcher instanceof AntPathRequestMatcher) {
                path = ((AntPathRequestMatcher)endpointMatcher).getPattern();
            } else if (endpointMatcher instanceof OrRequestMatcher) {
                OrRequestMatcher endpointMatchers = (OrRequestMatcher)endpointMatcher;
                Field requestMatchersField = FieldUtils.getDeclaredField(OrRequestMatcher.class, (String)"requestMatchers", (boolean)true);
                Iterable requestMatchers = (Iterable)requestMatchersField.get(endpointMatchers);
                for (RequestMatcher requestMatcher : requestMatchers) {
                    if (!(requestMatcher instanceof OrRequestMatcher)) continue;
                    OrRequestMatcher orRequestMatcher = (OrRequestMatcher)requestMatcher;
                    requestMatchersField = FieldUtils.getDeclaredField(OrRequestMatcher.class, (String)"requestMatchers", (boolean)true);
                    requestMatchers = (Iterable)requestMatchersField.get(orRequestMatcher);
                    for (RequestMatcher matcher : requestMatchers) {
                        if (!(matcher instanceof AntPathRequestMatcher)) continue;
                        path = ((AntPathRequestMatcher)matcher).getPattern();
                    }
                }
            }
            PathItem pathItem = new PathItem();
            switch (requestMethod) {
                case POST: {
                    pathItem.post(operation);
                    break;
                }
                case GET: {
                    pathItem.get(operation);
                    break;
                }
            }
            openAPI.getPaths().addPathItem(path, pathItem);
        }
        catch (ClassCastException | IllegalAccessException ignored) {
            LOGGER.trace(ignored.getMessage());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

