/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.activation.DataSource;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MimeDataSource
implements Comparable<MimeDataSource> {
    private final String name;
    private final DataSource dataSource;
    @Nullable
    private final String contentDescription;
    @Nullable
    private final String contentTransferEncoding;

    @Override
    public int compareTo(@NotNull MimeDataSource o) {
        int keyComparison = this.getName().compareTo(o.getName());
        if (keyComparison != 0) {
            return keyComparison;
        }
        return Integer.compare(this.getDataSource().hashCode(), o.getDataSource().hashCode());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MimeDataSource && this.compareTo((MimeDataSource)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataSource);
    }

    @Generated
    MimeDataSource(String name, DataSource dataSource, @Nullable String contentDescription, @Nullable String contentTransferEncoding) {
        this.name = name;
        this.dataSource = dataSource;
        this.contentDescription = contentDescription;
        this.contentTransferEncoding = contentTransferEncoding;
    }

    @Generated
    public static MimeDataSourceBuilder builder() {
        return new MimeDataSourceBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    @Generated
    public String getContentDescription() {
        return this.contentDescription;
    }

    @Nullable
    @Generated
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Generated
    public static class MimeDataSourceBuilder {
        @Generated
        private String name;
        @Generated
        private DataSource dataSource;
        @Generated
        private String contentDescription;
        @Generated
        private String contentTransferEncoding;

        @Generated
        MimeDataSourceBuilder() {
        }

        @Generated
        public MimeDataSourceBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MimeDataSourceBuilder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Generated
        public MimeDataSourceBuilder contentDescription(@Nullable String contentDescription) {
            this.contentDescription = contentDescription;
            return this;
        }

        @Generated
        public MimeDataSourceBuilder contentTransferEncoding(@Nullable String contentTransferEncoding) {
            this.contentTransferEncoding = contentTransferEncoding;
            return this;
        }

        @Generated
        public MimeDataSource build() {
            return new MimeDataSource(this.name, this.dataSource, this.contentDescription, this.contentTransferEncoding);
        }

        @Generated
        public String toString() {
            return "MimeDataSource.MimeDataSourceBuilder(name=" + this.name + ", dataSource=" + this.dataSource + ", contentDescription=" + this.contentDescription + ", contentTransferEncoding=" + this.contentTransferEncoding + ")";
        }
    }
}

