/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.model;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.simplejavamail.outlookmessageparser.model.OutlookMessageProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlookRecipient {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlookRecipient.class);
    private final Map<Integer, Object> properties = new TreeMap<Integer, Object>();
    private String name;
    private String address;
    private boolean nameWasUsedAsAddress = false;

    public void setProperty(OutlookMessageProperty msgProp) {
        String name = msgProp.getClazz();
        Object value = msgProp.getData();
        if (name == null || value == null) {
            return;
        }
        name = name.intern();
        int mapiClass = -1;
        try {
            mapiClass = Integer.parseInt(name, 16);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Unexpected mapi class: {}", (Object)name, (Object)e);
        }
        if (mapiClass == 12291 || mapiClass == 14846 || mapiClass == 12289) {
            this.handleNameAddressProperty(mapiClass, (String)value);
        }
        this.properties.put(mapiClass, value);
    }

    private void handleNameAddressProperty(int mapiClass, String probablyNamePossiblyAddress) {
        if (mapiClass == 12291 || mapiClass == 14846) {
            if ((this.address == null || this.nameWasUsedAsAddress) && probablyNamePossiblyAddress.contains("@")) {
                this.setAddress(probablyNamePossiblyAddress);
                this.nameWasUsedAsAddress = false;
            }
        } else if (mapiClass == 12289) {
            this.setName(probablyNamePossiblyAddress);
            if (this.address == null && probablyNamePossiblyAddress.contains("@")) {
                this.setAddress(probablyNamePossiblyAddress);
                this.nameWasUsedAsAddress = true;
            } else if (this.address == null && probablyNamePossiblyAddress.startsWith("/o=ExchangeLabs/ou=Exchange Administrative Group")) {
                this.setAddress(probablyNamePossiblyAddress);
                this.nameWasUsedAsAddress = false;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlookRecipient that = (OutlookRecipient)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (sb.length() > 0) {
            sb.append(" ");
        }
        if (this.address != null && this.address.length() > 0) {
            sb.append("<").append(this.address).append(">");
        }
        return sb.toString();
    }

    public Set<Integer> getPropertyCodes() {
        return this.properties.keySet();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }
}

