/*
 * Decompiled with CFR 0.152.
 */
package org.shipkit.auto.version;

import java.util.Collection;
import java.util.Optional;
import org.shipkit.auto.version.VersionConfig;
import org.shipkit.auto.version.VersionNumber;

class PreviousVersionFinder {
    PreviousVersionFinder() {
    }

    Optional<VersionNumber> findPreviousVersion(Collection<VersionNumber> versions, VersionConfig config) {
        if (config.getVersionSpec().isPresent() && !config.isWildcard()) {
            return this.findPrevious(versions, new VersionNumber(config.getVersionSpec().get()));
        }
        Optional<VersionNumber> max = versions.stream().filter(v -> v.satisfies(config.getVersionSpec().get())).max(VersionNumber::compareTo);
        if (max.isPresent()) {
            return max;
        }
        String newPatchVersion = config.newPatchVersion();
        return this.findPrevious(versions, new VersionNumber(newPatchVersion));
    }

    private Optional<VersionNumber> findPrevious(Collection<VersionNumber> versions, VersionNumber version) {
        return versions.stream().filter(v -> v.compareTo(version) < 0).max(VersionNumber::compareTo);
    }
}

