/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.page.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum ClientNavigationDisposition {
    CURRENTTAB("currentTab"),
    NEWTAB("newTab"),
    NEWWINDOW("newWindow"),
    DOWNLOAD("download");

    private String value;

    private ClientNavigationDisposition(String value) {
        this.value = value;
    }

    public static ClientNavigationDisposition fromString(String s) {
        return Arrays.stream(ClientNavigationDisposition.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ClientNavigationDisposition "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ClientNavigationDisposition fromJson(JsonInput input) {
        return ClientNavigationDisposition.fromString(input.nextString());
    }
}

