package org.openqa.selenium.devtools.v129.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS Layer data.
 */
@org.openqa.selenium.Beta()
public class CSSLayerData {

    private final java.lang.String name;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v129.css.model.CSSLayerData>> subLayers;

    private final java.lang.Number order;

    public CSSLayerData(java.lang.String name, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v129.css.model.CSSLayerData>> subLayers, java.lang.Number order) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.subLayers = subLayers;
        this.order = java.util.Objects.requireNonNull(order, "order is required");
    }

    /**
     * Layer name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Direct sub-layers
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v129.css.model.CSSLayerData>> getSubLayers() {
        return subLayers;
    }

    /**
     * Layer order. The order determines the order of the layer in the cascade order.
     * A higher number has higher priority in the cascade order.
     */
    public java.lang.Number getOrder() {
        return order;
    }

    private static CSSLayerData fromJson(JsonInput input) {
        java.lang.String name = null;
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v129.css.model.CSSLayerData>> subLayers = java.util.Optional.empty();
        java.lang.Number order = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "subLayers":
                    subLayers = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v129.css.model.CSSLayerData.class));
                    break;
                case "order":
                    order = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSLayerData(name, subLayers, order);
    }
}
