/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v127.layertree;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v127.dom.model.Rect;
import org.openqa.selenium.devtools.v127.layertree.model.Layer;
import org.openqa.selenium.devtools.v127.layertree.model.LayerId;
import org.openqa.selenium.devtools.v127.layertree.model.LayerPainted;
import org.openqa.selenium.devtools.v127.layertree.model.PaintProfile;
import org.openqa.selenium.devtools.v127.layertree.model.PictureTile;
import org.openqa.selenium.devtools.v127.layertree.model.SnapshotId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class LayerTree {
    public static Command<CompositingReasonsResponse> compositingReasons(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        LinkedHashMap<String, LayerId> params = new LinkedHashMap<String, LayerId>();
        params.put("layerId", layerId);
        return new Command("LayerTree.compositingReasons", Map.copyOf(params), input -> (CompositingReasonsResponse)input.read(CompositingReasonsResponse.class));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("LayerTree.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("LayerTree.enable", Map.copyOf(params));
    }

    public static Command<SnapshotId> loadSnapshot(List<PictureTile> tiles) {
        Objects.requireNonNull(tiles, "tiles is required");
        LinkedHashMap<String, List<PictureTile>> params = new LinkedHashMap<String, List<PictureTile>>();
        params.put("tiles", tiles);
        return new Command("LayerTree.loadSnapshot", Map.copyOf(params), ConverterFunctions.map((String)"snapshotId", SnapshotId.class));
    }

    public static Command<SnapshotId> makeSnapshot(LayerId layerId) {
        Objects.requireNonNull(layerId, "layerId is required");
        LinkedHashMap<String, LayerId> params = new LinkedHashMap<String, LayerId>();
        params.put("layerId", layerId);
        return new Command("LayerTree.makeSnapshot", Map.copyOf(params), ConverterFunctions.map((String)"snapshotId", SnapshotId.class));
    }

    public static Command<List<PaintProfile>> profileSnapshot(SnapshotId snapshotId, Optional<Integer> minRepeatCount, Optional<Number> minDuration, Optional<Rect> clipRect) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        minRepeatCount.ifPresent(p -> params.put("minRepeatCount", (SnapshotId)p));
        minDuration.ifPresent(p -> params.put("minDuration", (SnapshotId)p));
        clipRect.ifPresent(p -> params.put("clipRect", (SnapshotId)p));
        return new Command("LayerTree.profileSnapshot", Map.copyOf(params), ConverterFunctions.map((String)"timings", input -> input.readArray(PaintProfile.class)));
    }

    public static Command<Void> releaseSnapshot(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        return new Command("LayerTree.releaseSnapshot", Map.copyOf(params));
    }

    public static Command<String> replaySnapshot(SnapshotId snapshotId, Optional<Integer> fromStep, Optional<Integer> toStep, Optional<Number> scale) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        fromStep.ifPresent(p -> params.put("fromStep", (SnapshotId)p));
        toStep.ifPresent(p -> params.put("toStep", (SnapshotId)p));
        scale.ifPresent(p -> params.put("scale", (SnapshotId)p));
        return new Command("LayerTree.replaySnapshot", Map.copyOf(params), ConverterFunctions.map((String)"dataURL", String.class));
    }

    public static Command<List<Map<String, Object>>> snapshotCommandLog(SnapshotId snapshotId) {
        Objects.requireNonNull(snapshotId, "snapshotId is required");
        LinkedHashMap<String, SnapshotId> params = new LinkedHashMap<String, SnapshotId>();
        params.put("snapshotId", snapshotId);
        return new Command("LayerTree.snapshotCommandLog", Map.copyOf(params), ConverterFunctions.map((String)"commandLog", input -> input.readArray(Map.class)));
    }

    public static Event<LayerPainted> layerPainted() {
        return new Event("LayerTree.layerPainted", input -> (LayerPainted)input.read(LayerPainted.class));
    }

    public static Event<List<Layer>> layerTreeDidChange() {
        return new Event("LayerTree.layerTreeDidChange", ConverterFunctions.map((String)"layers", input -> input.readArray(Layer.class)));
    }

    public static class CompositingReasonsResponse {
        private final List<String> compositingReasons;
        private final List<String> compositingReasonIds;

        public CompositingReasonsResponse(List<String> compositingReasons, List<String> compositingReasonIds) {
            this.compositingReasons = Objects.requireNonNull(compositingReasons, "compositingReasons is required");
            this.compositingReasonIds = Objects.requireNonNull(compositingReasonIds, "compositingReasonIds is required");
        }

        public List<String> getCompositingReasons() {
            return this.compositingReasons;
        }

        public List<String> getCompositingReasonIds() {
            return this.compositingReasonIds;
        }

        private static CompositingReasonsResponse fromJson(JsonInput input) {
            List compositingReasons = null;
            List compositingReasonIds = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "compositingReasons": {
                        compositingReasons = input.readArray(String.class);
                        continue block8;
                    }
                    case "compositingReasonIds": {
                        compositingReasonIds = input.readArray(String.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CompositingReasonsResponse(compositingReasons, compositingReasonIds);
        }
    }
}

