/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v119.overlay.model;

import java.util.Optional;
import org.openqa.selenium.devtools.v119.dom.model.RGBA;
import org.openqa.selenium.devtools.v119.overlay.model.LineStyle;
import org.openqa.selenium.json.JsonInput;

public class ScrollSnapContainerHighlightConfig {
    private final Optional<LineStyle> snapportBorder;
    private final Optional<LineStyle> snapAreaBorder;
    private final Optional<RGBA> scrollMarginColor;
    private final Optional<RGBA> scrollPaddingColor;

    public ScrollSnapContainerHighlightConfig(Optional<LineStyle> snapportBorder, Optional<LineStyle> snapAreaBorder, Optional<RGBA> scrollMarginColor, Optional<RGBA> scrollPaddingColor) {
        this.snapportBorder = snapportBorder;
        this.snapAreaBorder = snapAreaBorder;
        this.scrollMarginColor = scrollMarginColor;
        this.scrollPaddingColor = scrollPaddingColor;
    }

    public Optional<LineStyle> getSnapportBorder() {
        return this.snapportBorder;
    }

    public Optional<LineStyle> getSnapAreaBorder() {
        return this.snapAreaBorder;
    }

    public Optional<RGBA> getScrollMarginColor() {
        return this.scrollMarginColor;
    }

    public Optional<RGBA> getScrollPaddingColor() {
        return this.scrollPaddingColor;
    }

    private static ScrollSnapContainerHighlightConfig fromJson(JsonInput input) {
        Optional<LineStyle> snapportBorder = Optional.empty();
        Optional<LineStyle> snapAreaBorder = Optional.empty();
        Optional<RGBA> scrollMarginColor = Optional.empty();
        Optional<RGBA> scrollPaddingColor = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "snapportBorder": {
                    snapportBorder = Optional.ofNullable((LineStyle)input.read(LineStyle.class));
                    continue block12;
                }
                case "snapAreaBorder": {
                    snapAreaBorder = Optional.ofNullable((LineStyle)input.read(LineStyle.class));
                    continue block12;
                }
                case "scrollMarginColor": {
                    scrollMarginColor = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block12;
                }
                case "scrollPaddingColor": {
                    scrollPaddingColor = Optional.ofNullable((RGBA)input.read(RGBA.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScrollSnapContainerHighlightConfig(snapportBorder, snapAreaBorder, scrollMarginColor, scrollPaddingColor);
    }
}

