package org.openqa.selenium.devtools.v112.input.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class TouchPoint {

    private final java.lang.Number x;

    private final java.lang.Number y;

    private final java.util.Optional<java.lang.Number> radiusX;

    private final java.util.Optional<java.lang.Number> radiusY;

    private final java.util.Optional<java.lang.Number> rotationAngle;

    private final java.util.Optional<java.lang.Number> force;

    private final java.util.Optional<java.lang.Number> tangentialPressure;

    private final java.util.Optional<java.lang.Integer> tiltX;

    private final java.util.Optional<java.lang.Integer> tiltY;

    private final java.util.Optional<java.lang.Integer> twist;

    private final java.util.Optional<java.lang.Number> id;

    public TouchPoint(java.lang.Number x, java.lang.Number y, java.util.Optional<java.lang.Number> radiusX, java.util.Optional<java.lang.Number> radiusY, java.util.Optional<java.lang.Number> rotationAngle, java.util.Optional<java.lang.Number> force, java.util.Optional<java.lang.Number> tangentialPressure, java.util.Optional<java.lang.Integer> tiltX, java.util.Optional<java.lang.Integer> tiltY, java.util.Optional<java.lang.Integer> twist, java.util.Optional<java.lang.Number> id) {
        this.x = java.util.Objects.requireNonNull(x, "x is required");
        this.y = java.util.Objects.requireNonNull(y, "y is required");
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.rotationAngle = rotationAngle;
        this.force = force;
        this.tangentialPressure = tangentialPressure;
        this.tiltX = tiltX;
        this.tiltY = tiltY;
        this.twist = twist;
        this.id = id;
    }

    /**
     * X coordinate of the event relative to the main frame's viewport in CSS pixels.
     */
    public java.lang.Number getX() {
        return x;
    }

    /**
     * Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to
     * the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.
     */
    public java.lang.Number getY() {
        return y;
    }

    /**
     * X radius of the touch area (default: 1.0).
     */
    public java.util.Optional<java.lang.Number> getRadiusX() {
        return radiusX;
    }

    /**
     * Y radius of the touch area (default: 1.0).
     */
    public java.util.Optional<java.lang.Number> getRadiusY() {
        return radiusY;
    }

    /**
     * Rotation angle (default: 0.0).
     */
    public java.util.Optional<java.lang.Number> getRotationAngle() {
        return rotationAngle;
    }

    /**
     * Force (default: 1.0).
     */
    public java.util.Optional<java.lang.Number> getForce() {
        return force;
    }

    /**
     * The normalized tangential pressure, which has a range of [-1,1] (default: 0).
     */
    @Beta()
    public java.util.Optional<java.lang.Number> getTangentialPressure() {
        return tangentialPressure;
    }

    /**
     * The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)
     */
    @Beta()
    public java.util.Optional<java.lang.Integer> getTiltX() {
        return tiltX;
    }

    /**
     * The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0).
     */
    @Beta()
    public java.util.Optional<java.lang.Integer> getTiltY() {
        return tiltY;
    }

    /**
     * The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0).
     */
    @Beta()
    public java.util.Optional<java.lang.Integer> getTwist() {
        return twist;
    }

    /**
     * Identifier used to track touch sources between events, must be unique within an event.
     */
    public java.util.Optional<java.lang.Number> getId() {
        return id;
    }

    private static TouchPoint fromJson(JsonInput input) {
        java.lang.Number x = 0;
        java.lang.Number y = 0;
        java.util.Optional<java.lang.Number> radiusX = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> radiusY = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> rotationAngle = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> force = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> tangentialPressure = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> tiltX = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> tiltY = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> twist = java.util.Optional.empty();
        java.util.Optional<java.lang.Number> id = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "x":
                    x = input.nextNumber();
                    break;
                case "y":
                    y = input.nextNumber();
                    break;
                case "radiusX":
                    radiusX = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "radiusY":
                    radiusY = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "rotationAngle":
                    rotationAngle = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "force":
                    force = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "tangentialPressure":
                    tangentialPressure = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                case "tiltX":
                    tiltX = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "tiltY":
                    tiltY = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "twist":
                    twist = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "id":
                    id = java.util.Optional.ofNullable(input.nextNumber());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new TouchPoint(x, y, radiusX, radiusY, rotationAngle, force, tangentialPressure, tiltX, tiltY, twist, id);
    }
}
