package org.openqa.selenium.devtools.v112.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum TwaQualityEnforcementViolationType {

    KHTTPERROR("kHttpError"), KUNAVAILABLEOFFLINE("kUnavailableOffline"), KDIGITALASSETLINKS("kDigitalAssetLinks");

    private String value;

    TwaQualityEnforcementViolationType(String value) {
        this.value = value;
    }

    public static TwaQualityEnforcementViolationType fromString(String s) {
        return java.util.Arrays.stream(TwaQualityEnforcementViolationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within TwaQualityEnforcementViolationType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static TwaQualityEnforcementViolationType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
