/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.cli;

import com.martiansoftware.nailgun.NGContext;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import metaconfig.Configured;
import org.scalafmt.Versions$;
import org.scalafmt.cli.CliArgParser$;
import org.scalafmt.cli.CliOptions;
import org.scalafmt.cli.CliOptions$;
import org.scalafmt.cli.CommonOptions;
import org.scalafmt.cli.ExitCode;
import org.scalafmt.cli.ExitCode$;
import org.scalafmt.cli.FileFetchMode;
import org.scalafmt.cli.ScalafmtCoreRunner$;
import org.scalafmt.cli.ScalafmtDynamicRunner$;
import org.scalafmt.cli.ScalafmtRunner;
import org.scalafmt.cli.WriteMode;
import org.scalafmt.cli.WriteMode$Test$;
import org.scalafmt.config.ConfParsed;
import org.scalafmt.config.ConfParsed$;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.sysops.AbsoluteFile;
import org.scalafmt.sysops.AbsoluteFile$;
import org.scalafmt.sysops.GitOps;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;
import scala.util.control.NoStackTrace;

public final class Cli$ {
    public static final Cli$ MODULE$ = new Cli$();
    private static final boolean isNativeImage = "true".equals(System.getProperty("scalafmt.native-image", "false"));

    public void nailMain(NGContext nGContext) {
        Path workingDirectory = ((AbsoluteFile)AbsoluteFile$.MODULE$.fromPathIfAbsolute(nGContext.getWorkingDirectory()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(65).append("Expected absolute path, ").append("obtained nGContext.getWorkingDirectory = ").append(nGContext.getWorkingDirectory()).toString());
        })).path();
        CommonOptions x$1 = CliOptions$.MODULE$.default().common().copy((Option<AbsoluteFile>)new Some((Object)new AbsoluteFile(workingDirectory)), nGContext.out, nGContext.in, nGContext.err, CliOptions$.MODULE$.default().common().copy$default$5(), CliOptions$.MODULE$.default().common().copy$default$6());
        Option<Path> x$2 = CliOptions$.MODULE$.default().copy$default$1();
        ScalafmtConfig x$3 = CliOptions$.MODULE$.default().copy$default$2();
        Option<String> x$4 = CliOptions$.MODULE$.default().copy$default$3();
        Set<Range> x$5 = CliOptions$.MODULE$.default().copy$default$4();
        Seq<Path> x$6 = CliOptions$.MODULE$.default().copy$default$5();
        Seq<String> x$7 = CliOptions$.MODULE$.default().copy$default$6();
        boolean x$8 = CliOptions$.MODULE$.default().copy$default$7();
        boolean x$9 = CliOptions$.MODULE$.default().copy$default$8();
        Option<FileFetchMode> x$10 = CliOptions$.MODULE$.default().copy$default$9();
        String x$11 = CliOptions$.MODULE$.default().copy$default$10();
        GitOps.Factory x$12 = CliOptions$.MODULE$.default().copy$default$12();
        Option<WriteMode> x$13 = CliOptions$.MODULE$.default().copy$default$13();
        boolean x$14 = CliOptions$.MODULE$.default().copy$default$14();
        boolean x$15 = CliOptions$.MODULE$.default().copy$default$15();
        boolean x$16 = CliOptions$.MODULE$.default().copy$default$16();
        boolean x$17 = CliOptions$.MODULE$.default().copy$default$17();
        boolean x$18 = CliOptions$.MODULE$.default().copy$default$18();
        boolean x$19 = CliOptions$.MODULE$.default().copy$default$19();
        ExitCode exit = this.mainWithOptions(nGContext.getArgs(), CliOptions$.MODULE$.default().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$1, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19));
        nGContext.exit(exit.code());
    }

    private void throwIfError(ExitCode exit) {
        ExitCode exitCode = exit;
        ExitCode exitCode2 = ExitCode$.MODULE$.Ok();
        if (exitCode == null ? exitCode2 != null : !((Object)exitCode).equals(exitCode2)) {
            throw new NoStackTrace(exit){

                public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                    return super.fillInStackTrace();
                }

                public Throwable fillInStackTrace() {
                    return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
                }
                {
                    NoStackTrace.$init$((NoStackTrace)this);
                }
            };
        }
    }

    public void main(String[] args) {
        ExitCode exit = this.mainWithOptions(args, CliOptions$.MODULE$.default());
        throw scala.sys.package$.MODULE$.exit(exit.code());
    }

    public void exceptionThrowingMain(String[] args) {
        this.exceptionThrowingMainWithOptions(args, CliOptions$.MODULE$.default());
    }

    public void exceptionThrowingMainWithOptions(String[] args, CliOptions options) {
        ExitCode exit = this.mainWithOptions(args, options);
        this.throwIfError(exit);
    }

    public ExitCode mainWithOptions(String[] args, CliOptions options) {
        Option<CliOptions> option = this.getConfig(args, options);
        if (option instanceof Some) {
            Some some = (Some)option;
            CliOptions x = (CliOptions)some.value();
            return this.run(x);
        }
        if (None$.MODULE$.equals(option)) {
            return ExitCode$.MODULE$.CommandLineArgumentError();
        }
        throw new MatchError(option);
    }

    public Option<CliOptions> getConfig(String[] args, CliOptions init) {
        Seq<String> expandedArguments = this.expandArguments((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)args));
        return CliArgParser$.MODULE$.scoptParser().parse(expandedArguments, (Object)init).map((Function1 & Serializable)parsed -> CliOptions$.MODULE$.auto((CliOptions)parsed));
    }

    private Seq<String> expandArguments(Seq<String> args) {
        Builder builder = package$.MODULE$.Seq().newBuilder();
        args.foreach((Function1 & Serializable)arg -> {
            String atFile;
            String string = atFile = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(arg), "@");
            String string2 = arg;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return (Builder)builder.$plus$eq(arg);
            }
            String string3 = atFile;
            String string4 = "-";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                return (Builder)builder.$plus$plus$eq((IterableOnce)Source$.MODULE$.stdin().getLines());
            }
            if (!Files.isRegularFile(Paths.get(atFile, new String[0]), new LinkOption[0])) {
                return (Builder)builder.$plus$eq(arg);
            }
            return (Builder)Using$.MODULE$.resource((Object)Source$.MODULE$.fromFile(atFile, Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)x$1 -> (Builder)builder.$plus$plus$eq((IterableOnce)x$1.getLines()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        });
        return (Seq)builder.result();
    }

    public ExitCode run(CliOptions options) {
        Either<String, ScalafmtRunner> either = this.findRunner(options);
        if (either instanceof Left) {
            Left left = (Left)either;
            String message = (String)left.value();
            options.common().err().println(message);
            return ExitCode$.MODULE$.UnsupportedVersion();
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            ScalafmtRunner runner = (ScalafmtRunner)right.value();
            return this.runWithRunner(options, runner);
        }
        throw new MatchError(either);
    }

    private boolean isNativeImage() {
        return isNativeImage;
    }

    private String getProposedConfigVersion(CliOptions options) {
        return new StringBuilder(10).append("version = ").append(Versions$.MODULE$.stable()).toString();
    }

    private Either<String, ScalafmtRunner> findRunner(CliOptions options) {
        Either versionOpt = (Either)options.hoconOpt().map((Function1 & Serializable)x -> Cli$.$anonfun$findRunner$1(((ConfParsed)x).conf())).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(113).append("error: missing Scalafmt configuration file.\n        |Consider creating '").append(options.getProposedConfigFile()).append("' with the following:\n        |").append(MODULE$.getProposedConfigVersion(options)).append("\n        |").toString()))));
        return versionOpt.flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Some some = null;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                Option<String> option2 = options.configStr();
                String where = None$.MODULE$.equals(option2) ? options.canonicalConfigFile().fold((Function0 & Serializable)() -> options.getProposedConfigFile(), (Function1 & Serializable)x$2 -> (Path)x$2.get()).toString() : "--config-str option";
                return package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("error: missing Scalafmt version.\n          |Consider adding the following to ").append(where).append(":\n          |").append(MODULE$.getProposedConfigVersion(options)).append("\n          |").toString())));
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                String string = (String)some.value();
                String string2 = Versions$.MODULE$.stable();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    options.common().debug().println(new StringBuilder(20).append("Using core runner [").append(Versions$.MODULE$.stable()).append("]").toString());
                    return package$.MODULE$.Right().apply((Object)ScalafmtCoreRunner$.MODULE$);
                }
            }
            if (bl) {
                String v = (String)some.value();
                if (MODULE$.isNativeImage()) {
                    return package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(499).append("error: invalid Scalafmt version.\n            |\n            |This Scalafmt installation has version '").append(Versions$.MODULE$.stable()).append("' and the version configured in '").append(options.configPath()).append("' is '").append(v).append("'.\n            |To fix this problem, add the following line to .scalafmt.conf:\n            |```\n            |version = ").append(Versions$.MODULE$.stable()).append("\n            |```\n            |\n            |NOTE: this error happens only when running a native Scalafmt binary.\n            |Scalafmt automatically installs and invokes the correct version of Scalafmt when running on the JVM.\n            |").toString())));
                }
            }
            if (bl) {
                String v = (String)some.value();
                options.common().debug().println(new StringBuilder(23).append("Using dynamic runner [").append(v).append("]").toString());
                return package$.MODULE$.Right().apply((Object)ScalafmtDynamicRunner$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    public ExitCode runWithRunner(CliOptions options, ScalafmtRunner runner) {
        WriteMode writeMode = options.writeMode();
        WriteMode$Test$ writeMode$Test$ = WriteMode$Test$.MODULE$;
        String termDisplayMessage = !(writeMode != null ? !writeMode.equals(writeMode$Test$) : writeMode$Test$ != null) ? "Looking for unformatted files..." : "Reformatting...";
        options.common().debug().println(new StringBuilder(19).append("Working directory: ").append(new AbsoluteFile(options.cwd())).toString());
        ExitCode exit = runner.run(options, termDisplayMessage);
        WriteMode writeMode2 = options.writeMode();
        WriteMode$Test$ writeMode$Test$2 = WriteMode$Test$.MODULE$;
        if (!(writeMode2 != null ? !writeMode2.equals(writeMode$Test$2) : writeMode$Test$2 != null)) {
            if (exit.isOk()) {
                options.common().out().println("All files are formatted with scalafmt :)");
            } else if (exit.is(ExitCode$.MODULE$.TestError())) {
                options.common().out().println("error: --test failed");
                options.onTestFailure().foreach((Function1 & Serializable)x$1 -> {
                    Cli$.$anonfun$runWithRunner$1(options, x$1);
                    return BoxedUnit.UNIT;
                });
            } else {
                options.common().out().println(new StringBuilder(7).append("error: ").append(exit).toString());
            }
        }
        WriteMode writeMode3 = options.writeMode();
        WriteMode$Test$ writeMode$Test$3 = WriteMode$Test$.MODULE$;
        if (!(writeMode3 != null ? !writeMode3.equals(writeMode$Test$3) : writeMode$Test$3 != null)) {
            if (!options.fatalWarnings() && exit.is(ExitCode$.MODULE$.ParseError())) {
                return ExitCode$.MODULE$.Ok();
            }
        }
        return exit;
    }

    public static final /* synthetic */ Right $anonfun$findRunner$1(Configured x) {
        return package$.MODULE$.Right().apply((Object)ConfParsed$.MODULE$.version$extension(x));
    }

    public static final /* synthetic */ void $anonfun$runWithRunner$1(CliOptions options$2, String x$1) {
        options$2.common().out().println(x$1);
    }

    private Cli$() {
    }
}

