/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.TypeUtility;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class YamlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_YAML, MediaType.TEXT_YAML};
    private final ObjectMapper _mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public YamlMediaTypeFactory() {
        this._mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    public String toMarshaled(Object aObject) throws MarshalException {
        try {
            return this._mapper.writeValueAsString(aObject);
        }
        catch (Exception e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + aObject.getClass().getName() + ">.", (Throwable)e);
        }
    }

    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType) throws UnmarshalException {
        try {
            if (aHttpBody == null) {
                return null;
            }
            if (aHttpBody.isEmpty()) {
                return aType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)this._mapper.readValue(aHttpBody, aType);
        }
        catch (JsonParseException | JsonMappingException e) {
            if (aType.isArray()) {
                try {
                    Map theMap = (Map)this._mapper.readValue(aHttpBody, Map.class);
                    return (T)TypeUtility.toArrayType((Object)theMap, aType);
                }
                catch (JsonProcessingException e2) {
                    throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
                }
            }
            if (Map.class.isAssignableFrom(aType)) {
                try {
                    Map theMap = Map.class.equals(aType) ? new HashMap() : (Map)aType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Object[] theArray = (Object[])this._mapper.readValue(aHttpBody, Object[].class);
                    if (theArray != null) {
                        for (int i = 0; i < theArray.length; ++i) {
                            if (theArray[i] == null) continue;
                            theMap.put(Integer.toString(i), theArray[i]);
                        }
                    }
                    return (T)theMap;
                }
                catch (JsonProcessingException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                    throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
                }
            }
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the HTTP body \"" + aHttpBody + "\" to type  <" + aType.getName() + ">!", (Throwable)e);
        }
    }
}

