/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.data.MarshalParameter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.ext.factory.XmlCanonicalMapFactorySingleton;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class XmlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_XML, MediaType.TEXT_XML, MediaType.APPLICATION_HAL_XML, MediaType.APPLICATION_SCHEMA_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    public <SRC> String toMarshaled(SRC aContext) throws MarshalException {
        return this.toMarshaled((Object)aContext, (Map)null);
    }

    public <SRC> String toMarshaled(SRC aObject, Map<String, String> aProperties) throws MarshalException {
        CanonicalMapBuilderImpl theCanoniocalMap = new CanonicalMapBuilderImpl(aObject);
        if (aObject.getClass().isArray()) {
            theCanoniocalMap = new CanonicalMapBuilderImpl((Object)theCanoniocalMap.retrieveTo(new String[]{"array", "value"}));
            theCanoniocalMap.put(new String[]{"array", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Collection.class.isAssignableFrom(aObject.getClass())) {
            theCanoniocalMap = new CanonicalMapBuilderImpl((Object)theCanoniocalMap.retrieveTo(new String[]{"collection", "value"}));
            theCanoniocalMap.put(new String[]{"collection", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Map.class.isAssignableFrom(aObject.getClass()) && theCanoniocalMap.dirs().size() == 0) {
            theCanoniocalMap = new CanonicalMapBuilderImpl((Object)theCanoniocalMap.retrieveTo(new String[]{"map", "value"}));
            theCanoniocalMap.put(new String[]{"map", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (theCanoniocalMap.children().size() > 1 || SimpleType.isSimpleType(aObject.getClass())) {
            String theRootElement;
            String string = theRootElement = aProperties != null ? aProperties.get(MarshalParameter.ROOT_ELEMENT.getName()) : null;
            if (theRootElement == null || theRootElement.isEmpty()) {
                theRootElement = "value";
            }
            theCanoniocalMap = new CanonicalMapBuilderImpl((Object)theCanoniocalMap.retrieveTo(theRootElement));
        }
        return XmlCanonicalMapFactorySingleton.getInstance().toMarshaled((CanonicalMap)theCanoniocalMap, aProperties);
    }

    public <T> T toUnmarshaled(String aContext, Class<T> aType) throws UnmarshalException {
        return this.toUnmarshaled(aContext, aType, null);
    }

    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType, Map<String, String> aProperties) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder theCanoniocalMap = XmlCanonicalMapFactorySingleton.getInstance().toUnmarshaled(aHttpBody, aProperties);
        if (aType.isArray() && theCanoniocalMap.isDir("array") && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir(new String[]{"array", "value"}) && theCanoniocalMap.dirs("array").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"array", "value"});
        }
        if (aType.isArray() && theCanoniocalMap.isDir("map") && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir(new String[]{"map", "value"}) && theCanoniocalMap.dirs("map").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"map", "value"});
        } else if (Collection.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir(new String[]{"collection", "value"}) && theCanoniocalMap.dirs("collection").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"collection", "value"});
        } else if (Map.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir(new String[]{"map", "value"}) && theCanoniocalMap.dirs("map").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"map", "value"});
        } else if (Map.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir(new String[]{"array", "value"}) && theCanoniocalMap.dirs("array").size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"array", "value"});
        } else {
            if (aType.isAssignableFrom(HttpBodyMap.class)) {
                return (T)((Object)new HttpBodyMap(theCanoniocalMap));
            }
            if (theCanoniocalMap.hasValue("value") && theCanoniocalMap.leaves().size() == 1 && theCanoniocalMap.dirs().size() == 0 || theCanoniocalMap.isDir("value") && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.dirs().size() == 1) {
                theCanoniocalMap = theCanoniocalMap.retrieveFrom("value");
            }
        }
        return (T)theCanoniocalMap.toType(aType);
    }

    @Override
    public <T> T fromMarshaled(InputStream aContentInputStream, Class<T> aType) throws UnmarshalException {
        return this.fromMarshaled(aContentInputStream, aType, (Map<String, String>)null);
    }

    @Override
    public Object fromMarshaled(InputStream aContentInputStream, Map<String, String> aProperties, Class<?> ... aTypes) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder theBuilder = XmlCanonicalMapFactorySingleton.getInstance().fromMarshaled(aContentInputStream, aProperties);
        for (Class<?> eType : aTypes) {
            try {
                return theBuilder.toType(eType);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

