/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Encoding;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.web.Cookie;

public class RequestCookie
extends PropertyImpl.PropertyBuilderImpl
implements Cookie {
    @Override
    public RequestCookie withHttpCookie(String aCookie) {
        this.fromHttpCookie(aCookie);
        return this;
    }

    @Override
    public void fromHttpCookie(String aHttpCookie) {
        PropertyImpl theProperty = new PropertyImpl(aHttpCookie);
        this.setKey((String)theProperty.getKey());
        try {
            this.setValue(URLDecoder.decode((String)theProperty.getValue(), Encoding.UTF_8.getCode()));
        }
        catch (UnsupportedEncodingException ignore) {
            this.setValue((String)theProperty.getValue());
        }
    }

    @Override
    public String toHttpCookie() {
        String theValue = null;
        try {
            theValue = URLEncoder.encode((String)this.getValue(), Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException ignore) {
            theValue = (String)this.getValue();
        }
        return (String)this.getKey() + Delimiter.COOKIE_TUPEL.getChar() + theValue;
    }

    public String toString() {
        return this.getClass().getName() + "@[key=" + (String)this._key + ", value=" + (String)this._value + "]";
    }

    public RequestCookie() {
    }

    public RequestCookie(String aCookieName, String aValue) {
        super(aCookieName, aValue);
    }

    public RequestCookie(String aHttpCookie) {
        this.fromHttpCookie(aHttpCookie);
    }
}

