/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.data.Delimiter;
import org.refcodes.data.Scheme;
import org.refcodes.runtime.EnvironmentVariable;
import org.refcodes.runtime.SystemProperty;

public enum Proxy {
    HTTP(EnvironmentVariable.HTTP_PROXY, SystemProperty.HTTP_PROXY_HOST, SystemProperty.HTTP_PROXY_PORT, Scheme.HTTP),
    HTTPS(EnvironmentVariable.HTTPS_PROXY, SystemProperty.HTTPS_PROXY_HOST, SystemProperty.HTTPS_PROXY_PORT, Scheme.HTTPS),
    SOCKS(EnvironmentVariable.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Scheme.SOCKS),
    SOCKS4(EnvironmentVariable.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Scheme.SOCKS4),
    SOCKS5(EnvironmentVariable.HTTP_PROXY, SystemProperty.SOCKS_PROXY_HOST, SystemProperty.SOCKS_PROXY_PORT, Scheme.SOCKS5);

    private EnvironmentVariable _envProxy;
    private SystemProperty _sysHost;
    private SystemProperty _sysPort;
    private Scheme _protocol;

    private Proxy(EnvironmentVariable aEnvProxy, SystemProperty aSysHost, SystemProperty aSysPort, Scheme aProtocol) {
        this._envProxy = aEnvProxy;
        this._protocol = aProtocol;
        this._sysHost = aSysHost;
        this._sysPort = aSysPort;
    }

    public void initialize() {
        Proxy.toProxySettings(this._envProxy, this._sysHost, this._sysPort, this._protocol);
    }

    public static void initializeAll() {
        for (Proxy eProxy : Proxy.values()) {
            eProxy.initialize();
        }
    }

    protected static void toProxySettings(EnvironmentVariable aFromEnvProxy, SystemProperty aToSysHost, SystemProperty aToSysPort, Scheme aProtocol) {
        String theHttpProxy;
        if ((aToSysHost.getValue() == null || aToSysHost.getValue().isEmpty()) && (theHttpProxy = aFromEnvProxy.getValue()) != null && theHttpProxy.toLowerCase().startsWith(aProtocol.getMarker().toLowerCase())) {
            int index = theHttpProxy.lastIndexOf(Delimiter.URL_PORT.getChar());
            if (index != -1) {
                try {
                    int ePort = Integer.valueOf(theHttpProxy.substring(index + 1));
                    String eHost = theHttpProxy.substring(0, index);
                    aToSysHost.setValue(eHost);
                    aToSysPort.setValue(Integer.toString(ePort));
                }
                catch (Exception e) {
                    aToSysHost.setValue(theHttpProxy);
                }
            } else {
                aToSysHost.setValue(theHttpProxy);
            }
        }
    }
}

