/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.factory.MarshalFactory;
import org.refcodes.factory.UnmarshalFactory;
import org.refcodes.struct.PathMap;
import org.refcodes.web.MediaTypesAccessor;

public interface MediaTypeFactory
extends UnmarshalFactory.UnmarshalFactoryComposite<String, InputStream>,
MarshalFactory.MarshalFactoryComposite<String, InputStream>,
MediaTypesAccessor {
    public static final String VALUE_SELECTOR = "value";
    public static final String ARRAY_SELECTOR = "array";
    public static final String COLLECTION_SELECTOR = "collection";
    public static final String MAP_SELECTOR = "map";
    public static final String TYPE_ANNOTATION = PathMap.ANNOTATOR + "type";

    default public <T> T fromMarshaled(InputStream aContentInputStream, Class<T> aType) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aContentInputStream));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return (T)this.toUnmarshaled(theHttpBody, aType);
    }

    default public Object fromMarshaled(InputStream aContentInputStream, Class<?> ... aTypes) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aContentInputStream));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(theHttpBody, aTypes);
    }

    default public Object fromMarshaled(InputStream aContentInputStream, Map<String, String> aProperties, Class<?> ... aTypes) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aContentInputStream));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(theHttpBody, aProperties, aTypes);
    }

    default public <T> T fromMarshaled(InputStream aContentInputStream, Class<T> aType, Map<String, String> aProperties) throws UnmarshalException {
        BufferedReader theBuffer = new BufferedReader(new InputStreamReader(aContentInputStream));
        String theHttpBody = theBuffer.lines().collect(Collectors.joining("\n"));
        return (T)this.toUnmarshaled(theHttpBody, aType, aProperties);
    }

    default public <SRC> InputStream fromUnmarshaled(SRC aContext) throws MarshalException {
        return new ByteArrayInputStream(((String)this.toMarshaled(aContext)).getBytes(StandardCharsets.UTF_8));
    }

    default public <SRC> InputStream fromUnmarshaled(SRC aContext, Map<String, String> aProperties) throws MarshalException {
        return new ByteArrayInputStream(((String)this.toMarshaled(aContext, aProperties)).getBytes(StandardCharsets.UTF_8));
    }
}

