/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.HashMap;
import org.refcodes.exception.MarshalException;
import org.refcodes.struct.PathMap;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AbstractHttpRequest;
import org.refcodes.web.BadRequestException;
import org.refcodes.web.ContentType;
import org.refcodes.web.FormFields;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;

public class HttpClientRequest
extends AbstractHttpRequest
implements HttpBodyAccessor.HttpBodyProvider<BadRequestException>,
RedirectDepthAccessor.RedirectDepthProperty {
    public static final int DEFAULT_REDIRECT_DEPTH = -1;
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private int _redirectDepth = -1;
    private Object _request = null;

    public HttpClientRequest(HttpMethod aHttpMethod, Url aUrl, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, (Object)null, -1, aMediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod aHttpMethod, Url aUrl, Object aRequest, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, aRequest, -1, aMediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, aHeaderFields, aRequest, -1, aMediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod aHttpMethod, Url aUrl, int aRedirectDepth, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, (Object)null, aRedirectDepth, aMediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod aHttpMethod, Url aUrl, Object aRequest, int aRedirectDepth, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        this(aHttpMethod, aUrl, null, aRequest, aRedirectDepth, aMediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aHeaderFields);
        this._mediaTypeFactoryLookup = aMediaTypeFactoryLookup;
        this._redirectDepth = aRedirectDepth;
        this.setRequest(aRequest);
    }

    public <REQ> REQ getRequest() {
        return (REQ)this._request;
    }

    public <REQ> void setRequest(REQ aRequest) {
        this._request = aRequest;
        if (aRequest != null && this.getHeaderFields() != null && this.getHeaderFields().getContentType() == null) {
            this.getHeaderFields().putContentType(this.toPreferredContentType());
        }
    }

    @Override
    public String toHttpBody() throws BadRequestException {
        if (this._request == null) {
            return null;
        }
        HashMap<String, String> theProperties = null;
        ContentType theContentType = this.toPreferredContentType();
        MediaTypeFactory theFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(theContentType.getMediaType());
        String theCharset = theContentType.getCharsetParametrer();
        if (theCharset != null) {
            theProperties = new HashMap<String, String>();
            theProperties.put(MediaTypeParameter.CHARSET.getName(), theCharset);
        }
        if (theFactory == null) {
            throw new BadRequestException("No Media-Type factory found (added) for request's Media-Type <" + String.valueOf(theContentType) + "> (raw requested Media-Type is <" + String.valueOf(this.getHeaderFields().get(HeaderField.CONTENT_TYPE)) + ">)");
        }
        try {
            Object theRequest = this._request;
            if (this._request instanceof PathMap) {
                theRequest = ((PathMap)this._request).toDataStructure();
            }
            return (String)theFactory.toMarshaled(theRequest, theProperties);
        }
        catch (MarshalException e) {
            throw new BadRequestException("Unable to marshal request <" + String.valueOf(this.getRequest()) + "> to request's Media-Type <" + new VerboseTextBuilder().toString((Object[])theFactory.getMediaTypes()) + ">.", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [httpMethod=" + String.valueOf((Object)this._httpMethod) + ", url=" + String.valueOf(this._url) + "]";
    }

    private ContentType toPreferredContentType() {
        ContentType theContentType = this.getHeaderFields().getContentType();
        if (theContentType == null) {
            if (this._request instanceof FormFields && this._mediaTypeFactoryLookup.hasMediaTypeFactory(MediaType.APPLICATION_X_WWW_FORM_URLENCODED)) {
                return MediaType.APPLICATION_X_WWW_FORM_URLENCODED.toContentType();
            }
            MediaType[] theMediaTypes = this._mediaTypeFactoryLookup.getFactoryMediaTypes();
            if (theMediaTypes != null && theMediaTypes.length != 0) {
                this.getHeaderFields().putContentType(theMediaTypes[0]);
                theContentType = new ContentType(theMediaTypes[0]);
            }
        }
        return theContentType;
    }

    @Override
    public int getRedirectDepth() {
        return this._redirectDepth;
    }

    @Override
    public void setRedirectDepth(int aRedirectDepth) {
        this._redirectDepth = aRedirectDepth;
    }
}

