/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.Collection;
import java.util.regex.Pattern;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.web.HttpStatusCode;

public class HttpBodyMap
extends CanonicalMapBuilderImpl {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_CODE_PATH = "/status/code";
    public static final String STATUS_ALIAS_PATH = "/status/alias";
    public static final String STATUS_MESSAGE_PATH = "/status/aMessage";
    public static final String STATUS_EXCEPTION_PATH = "/status/exception";
    public static final String STATUS_TIMESTAMP_PATH = "/status/timestamp";

    public HttpBodyMap() {
    }

    public HttpBodyMap(Object aObj) {
        super(aObj);
    }

    public HttpBodyMap(String aToPath, Object aObj) {
        super(aToPath, aObj);
    }

    public HttpBodyMap(Object aObj, String aFromPath) {
        super(aObj, aFromPath);
    }

    public HttpBodyMap(String aToPath, Object aObj, String aFromPath) {
        super(aToPath, aObj, aFromPath);
    }

    private HttpBodyMap(PathMap<String> aPathMap) {
        for (String ePath : aPathMap.paths()) {
            this.put(ePath, (String)aPathMap.get((Object)ePath));
        }
    }

    public HttpBodyMap retrieveFrom(String aFromPath) {
        return new HttpBodyMap((PathMap<String>)super.retrieveFrom(aFromPath));
    }

    public HttpBodyMap retrieveTo(String aToPath) {
        return new HttpBodyMap((PathMap<String>)super.retrieveTo(aToPath));
    }

    public HttpBodyMap retrieveBetween(String aFromPath, String aToPath) {
        return new HttpBodyMap((PathMap<String>)super.retrieveBetween(aFromPath, aToPath));
    }

    public HttpBodyMap withPut(String aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    public HttpBodyMap getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    public HttpBodyMap getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(aPath, aIndex);
    }

    public String getStatusAlias() {
        return (String)this.get(STATUS_ALIAS_PATH);
    }

    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.toHttpStatusCode(this.getInt(STATUS_CODE_PATH));
    }

    public Class<?> getStatusException() {
        try {
            return Class.forName((String)this.get(STATUS_EXCEPTION_PATH));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getStatusMessage() {
        return (String)this.get(STATUS_MESSAGE_PATH);
    }

    public Long getStatusTimeStamp() {
        return this.getLong(STATUS_TIMESTAMP_PATH);
    }

    public boolean hasStatusAlias() {
        try {
            return this.getStatusAlias() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasStatusCode() {
        try {
            return this.getStatusCode() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasStatusException() {
        try {
            return Class.forName((String)this.get(STATUS_EXCEPTION_PATH)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasStatusMessage() {
        return this.containsKey(STATUS_MESSAGE_PATH);
    }

    public boolean hasStatusTimeStamp() {
        try {
            return this.getStatusTimeStamp() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public HttpBodyMap putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(Collection<?> aPathElements, int aIndex, PathMap<String> aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(int aIndex, Object aDir) {
        return this.putDirAt(this.getRootPath(), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(int aIndex, PathMap<String> aDir) {
        return this.putDirAt(this.getRootPath(), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(Object aPath, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPath), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(Object aPath, int aIndex, PathMap<String> aDir) {
        return this.putDirAt(this.toPath(aPath), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(Object[] aPathElements, int aIndex, PathMap<String> aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(String aPath, int aIndex, Object aDir) {
        HttpBodyMap theReplaced = this.removeDirAt(aPath, aIndex);
        this.insertTo(this.toPath(new Object[]{aPath, aIndex}), aDir);
        return theReplaced;
    }

    public HttpBodyMap putDirAt(String aPath, int aIndex, PathMap<String> aDir) {
        HttpBodyMap theReplaced = this.removeDirAt(aPath, aIndex);
        this.insertTo(this.toPath(new Object[]{aPath, aIndex}), aDir);
        return theReplaced;
    }

    public HttpBodyMap putDirAt(String[] aPathElements, int aIndex, Object aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    public HttpBodyMap putDirAt(String[] aPathElements, int aIndex, PathMap<String> aDir) {
        return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
    }

    public String putStatusAlias(HttpStatusCode aStatusCode) {
        return (String)this.put(STATUS_ALIAS_PATH, aStatusCode.toVerbose());
    }

    public String putStatusAlias(String aStatusAlias) {
        return (String)this.put(STATUS_ALIAS_PATH, aStatusAlias);
    }

    public String putStatusCode(HttpStatusCode aStatusCode) {
        return (String)this.putInt(STATUS_CODE_PATH, aStatusCode.getStatusCode());
    }

    public String putStatusCode(int aStatusCode) {
        return (String)this.putInt(STATUS_CODE_PATH, aStatusCode);
    }

    public String putStatusException(Class<Exception> aStatusException) {
        return (String)this.put(STATUS_EXCEPTION_PATH, aStatusException.getName());
    }

    public String putStatusException(Exception aStatusException) {
        return (String)this.put(STATUS_EXCEPTION_PATH, aStatusException.getClass().getName());
    }

    public String putStatusMessage(String aStatusMessage) {
        return (String)this.put(STATUS_MESSAGE_PATH, aStatusMessage);
    }

    public String putStatusTimeStamp() {
        return (String)this.putLong(STATUS_TIMESTAMP_PATH, System.currentTimeMillis());
    }

    public String putStatusTimeStamp(long aStatusTimeStamp) {
        return (String)this.putLong(STATUS_TIMESTAMP_PATH, aStatusTimeStamp);
    }

    public HttpBodyMap query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    public HttpBodyMap query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    public HttpBodyMap query(String aPathQuery) {
        return new HttpBodyMap((PathMap<String>)super.query(aPathQuery));
    }

    public HttpBodyMap query(Pattern aRegExp) {
        return new HttpBodyMap((PathMap<String>)super.query(aRegExp));
    }

    public HttpBodyMap query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    public HttpBodyMap queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap queryBetween(String aFromPath, String aPathQuery, String aToPath) {
        return new HttpBodyMap((PathMap<String>)super.queryBetween(aFromPath, aPathQuery, aToPath));
    }

    public HttpBodyMap queryBetween(String aFromPath, Pattern aRegExp, String aToPath) {
        return new HttpBodyMap((PathMap<String>)super.queryBetween(aFromPath, aRegExp, aToPath));
    }

    public HttpBodyMap queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    public HttpBodyMap queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    public HttpBodyMap queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    public HttpBodyMap queryFrom(String aPathQuery, String aFromPath) {
        return new HttpBodyMap((PathMap<String>)super.queryFrom(aPathQuery, aFromPath));
    }

    public HttpBodyMap queryFrom(Pattern aRegExp, String aFromPath) {
        return new HttpBodyMap((PathMap<String>)super.queryFrom(aRegExp, aFromPath));
    }

    public HttpBodyMap queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    public HttpBodyMap queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap queryTo(String aPathQuery, String aToPath) {
        return new HttpBodyMap((PathMap<String>)super.queryTo(aPathQuery, aToPath));
    }

    public HttpBodyMap queryTo(Pattern aRegExp, String aToPath) {
        return new HttpBodyMap((PathMap<String>)super.queryTo(aRegExp, aToPath));
    }

    public HttpBodyMap queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath(aToPath));
    }

    public HttpBodyMap removePaths(Collection<?> aPaths) {
        return new HttpBodyMap((PathMap<String>)super.removePaths(aPaths));
    }

    public HttpBodyMap removePaths(String ... aPaths) {
        return new HttpBodyMap((PathMap<String>)super.removePaths(aPaths));
    }

    public HttpBodyMap removeAll(String ... aPathQueryElements) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(aPathQueryElements));
    }

    public HttpBodyMap removeAll(Object ... aPathQueryElements) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(aPathQueryElements));
    }

    public HttpBodyMap removeAll(Collection<?> aPathQueryElements) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(aPathQueryElements));
    }

    public HttpBodyMap removeAll(String aPathQuery) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(aPathQuery));
    }

    public HttpBodyMap removeAll(Pattern aRegExp) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(aRegExp));
    }

    public HttpBodyMap removeAll(Object aPathQuery) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(aPathQuery));
    }

    public HttpBodyMap removeDirAt(int aIndex) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(aIndex));
    }

    public HttpBodyMap removeDirAt(Object aPath, int aIndex) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(aPath, aIndex));
    }

    public HttpBodyMap removeDirAt(Object[] aPathElements, int aIndex) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(aPathElements, aIndex));
    }

    public HttpBodyMap removeDirAt(String aPath, int aIndex) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(aPath, aIndex));
    }

    public HttpBodyMap removeDirAt(String[] aPathElements, int aIndex) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(aPathElements, aIndex));
    }

    public HttpBodyMap removeFrom(Object ... aPathElements) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(aPathElements));
    }

    public HttpBodyMap removeFrom(Object aPath) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(aPath));
    }

    public HttpBodyMap removeFrom(String aPath) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(aPath));
    }

    public HttpBodyMap removeFrom(String ... aPathElements) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(aPathElements));
    }

    public HttpBodyMap retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    public HttpBodyMap retrieveBetween(Object aFromPath, Object aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    public HttpBodyMap retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    public HttpBodyMap retrieveBetween(String[] aFromPath, String[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    public HttpBodyMap retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public HttpBodyMap retrieveFrom(Object aParentPath) {
        return this.retrieveFrom(this.toPath(aParentPath));
    }

    public HttpBodyMap retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public HttpBodyMap retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public HttpBodyMap retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public HttpBodyMap retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toPath(aToPath));
    }

    public HttpBodyMap retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public HttpBodyMap retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public HttpBodyMap withPutStatusAlias(HttpStatusCode aStatusCode) {
        this.put(STATUS_ALIAS_PATH, aStatusCode.toVerbose());
        return this;
    }

    public HttpBodyMap withPutStatusAlias(String aStatusAlias) {
        this.put(STATUS_ALIAS_PATH, aStatusAlias);
        return this;
    }

    public HttpBodyMap withPutStatusCode(HttpStatusCode aStatusCode) {
        this.putInt(STATUS_CODE_PATH, aStatusCode.getStatusCode());
        return this;
    }

    public HttpBodyMap withPutStatusCode(int aStatusCode) {
        this.putInt(STATUS_CODE_PATH, aStatusCode);
        return this;
    }

    public HttpBodyMap withPut(Collection<?> aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPut(Object[] aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPut(Relation<String, String> aProperty) {
        this.put(aProperty);
        return this;
    }

    public HttpBodyMap withPut(Property aProperty) {
        this.put(aProperty);
        return this;
    }

    public HttpBodyMap withPut(String[] aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutBoolean(Collection<?> aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutBoolean(Object aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutBoolean(Object[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutBoolean(String aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutBoolean(String[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutByte(Collection<?> aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutByte(Object aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutByte(Object[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutByte(String aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutByte(String[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutChar(Collection<?> aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutChar(Object aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutChar(Object[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutChar(String aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutChar(String[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    public <C> HttpBodyMap withPutClass(Collection<?> aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    public <C> HttpBodyMap withPutClass(Object aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    public <C> HttpBodyMap withPutClass(Object[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    public <C> HttpBodyMap withPutClass(String aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    public <C> HttpBodyMap withPutClass(String[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutDouble(Collection<?> aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutDouble(Object aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutDouble(Object[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutDouble(String aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutDouble(String[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(Collection<?> aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(Object aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(Object[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(String aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(String[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutFloat(Collection<?> aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutFloat(Object aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutFloat(Object[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutFloat(String aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutFloat(String[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutInt(Collection<?> aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutInt(Object aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutInt(Object[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutInt(String aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutInt(String[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutLong(Collection<?> aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutLong(Object aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutLong(Object[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutLong(String aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutLong(String[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutShort(Collection<?> aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutShort(Object aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutShort(Object[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutShort(String aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutShort(String[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutString(Collection<?> aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutString(Object aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutString(Object[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withPutString(String aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    public HttpBodyMap withPutString(String[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    public HttpBodyMap withInsert(Object aObj) {
        this.insert(aObj);
        return this;
    }

    public HttpBodyMap withInsert(PathMap<String> aFrom) {
        this.insert(aFrom);
        return this;
    }

    public HttpBodyMap withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object aFrom, Object ... aFromPathElements) {
        this.withInsertFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
        this.withInsertFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withInsertTo(Collection<?> aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(Object aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(Object aToPath, PathMap<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(Object[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(Object[] aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(String aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(String aToPath, PathMap<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(String[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withInsertTo(String[] aToPathElements, PathMap<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withMerge(Object aObj) {
        this.merge(aObj);
        return this;
    }

    public HttpBodyMap withMerge(PathMap<String> aFrom) {
        this.merge(aFrom);
        return this;
    }

    public HttpBodyMap withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeBetween(Collection<?> aToPathElements, PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object aToPath, PathMap<String> aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object[] aToPathElements, PathMap<String> aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFromPathElements, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeBetween(String aToPath, PathMap<String> aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeBetween(String[] aToPathElements, PathMap<String> aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    public HttpBodyMap withMergeTo(Collection<?> aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(Collection<?> aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(Object aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(Object aToPath, PathMap<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(Object[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(Object[] aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(String aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(String aToPath, PathMap<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(String[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withMergeTo(String[] aToPathElements, PathMap<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    public HttpBodyMap withPutDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(Collection<?> aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(int aIndex, Object aDir) {
        this.putDirAt(aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(int aIndex, PathMap<String> aDir) {
        this.putDirAt(aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object aPath, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object[] aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(String aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(String aPath, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withPutDirAt(String[] aPathElements, int aIndex, PathMap<String> aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    public HttpBodyMap withRemoveFrom(Collection<?> aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    public HttpBodyMap withRemoveFrom(Object aPath) {
        this.removeFrom(aPath);
        return this;
    }

    public HttpBodyMap withRemoveFrom(Object ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    public HttpBodyMap withRemoveFrom(String aPath) {
        this.removeFrom(aPath);
        return this;
    }

    public HttpBodyMap withRemoveFrom(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    public HttpBodyMap withRemovePaths(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }
}

