/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.ext.factory.HtmlCanonicalMapFactorySingleton;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class HtmlMediaTypeFactory
implements MediaTypeFactory {
    private static final MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.TEXT_HTML, MediaType.APPLICATION_XHTML_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    public <SRC> String toMarshaled(SRC aContext) throws MarshalException {
        return this.toMarshaled((Object)aContext, (Map)null);
    }

    public <SRC> String toMarshaled(SRC aObject, Map<String, String> aProperties) throws MarshalException {
        CanonicalMapBuilderImpl theCanoniocalMap = new CanonicalMapBuilderImpl(aObject);
        if (aObject.getClass().isArray()) {
            theCanoniocalMap = new CanonicalMapBuilderImpl((Object)theCanoniocalMap.retrieveTo(new String[]{"html", "body", "value"}));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Collection.class.isAssignableFrom(aObject.getClass())) {
            theCanoniocalMap = new CanonicalMapBuilderImpl((Object)theCanoniocalMap.retrieveTo(new String[]{"html", "body", "value"}));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        } else if (Map.class.isAssignableFrom(aObject.getClass()) && theCanoniocalMap.dirs().size() == 0) {
            theCanoniocalMap = new CanonicalMapBuilderImpl((Object)theCanoniocalMap.retrieveTo(new String[]{"html", "body", "value"}));
            theCanoniocalMap.put(new String[]{"html", "body", TYPE_ANNOTATION}, aObject.getClass().getName());
        }
        return HtmlCanonicalMapFactorySingleton.getInstance().toMarshaled((CanonicalMap)theCanoniocalMap, aProperties);
    }

    public <T> T toUnmarshaled(String aContext, Class<T> aType) throws UnmarshalException {
        return this.toUnmarshaled(aContext, aType, null);
    }

    public <T> T toUnmarshaled(String aHttpBody, Class<T> aType, Map<String, String> aProperties) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder theCanoniocalMap = HtmlCanonicalMapFactorySingleton.getInstance().toUnmarshaled(aHttpBody, aProperties);
        if (aType.isArray()) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"html", "body", "value"});
        } else if (Collection.class.isAssignableFrom(aType)) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"html", "body", "value"});
        } else if (Map.class.isAssignableFrom(aType) && theCanoniocalMap.dirs().size() == 1 && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.isDir(new String[]{"html", "body", "value"}) && theCanoniocalMap.dirs(new String[]{"html", "body"}).size() == 1) {
            theCanoniocalMap = theCanoniocalMap.retrieveFrom(new String[]{"html", "body", "value"});
        } else {
            if (aType.isAssignableFrom(HttpBodyMap.class)) {
                return (T)((Object)new HttpBodyMap(theCanoniocalMap));
            }
            theCanoniocalMap = theCanoniocalMap.hasValue(new String[]{"html", "body", "value"}) && theCanoniocalMap.leaves().size() == 1 && theCanoniocalMap.dirs().size() == 0 || theCanoniocalMap.isDir(new String[]{"html", "body", "value"}) && theCanoniocalMap.leaves().size() == 0 && theCanoniocalMap.dirs().size() == 1 ? theCanoniocalMap.retrieveFrom(new String[]{"html", "body", "value"}) : theCanoniocalMap.retrieveFrom(new String[]{"html", "body"});
        }
        return (T)theCanoniocalMap.toType(aType);
    }

    @Override
    public <T> T fromMarshaled(InputStream aContentInputStream, Class<T> aType) throws UnmarshalException {
        return this.fromMarshaled(aContentInputStream, aType, (Map<String, String>)null);
    }

    @Override
    public Object fromMarshaled(InputStream aContentInputStream, Map<String, String> aProperties, Class<?> ... aTypes) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder theBuilder = HtmlCanonicalMapFactorySingleton.getInstance().fromMarshaled(aContentInputStream, aProperties);
        for (Class<?> eType : aTypes) {
            try {
                return theBuilder.toType(eType);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

