/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.runtime.Terminal;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxGridImpl;

public enum TextBoxStyle implements TextBoxGrid
{
    SINGLE(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u251c\u2500\u253c\u2500\u2524", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    SINGLE_DASHED(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u251c\u2500\u253c\u2500\u2524", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    SINGLE_DOUBLE(new String[]{"\u2552\u2550\u2564\u2550\u2555", "\u2502 \u2502 \u2502", "\u255e\u2550\u256a\u2550\u2561", "\u2502 \u2502 \u2502", "\u2558\u2550\u2567\u2550\u255b"}),
    DOUBLE_SINGLE(new String[]{"\u2553\u2500\u2565\u2500\u2556", "\u2551 \u2551 \u2551", "\u255f\u2500\u256b\u2500\u2562", "\u2551 \u2551 \u2551", "\u2559\u2500\u2568\u2500\u255c"}),
    DOUBLE(new String[]{"\u2554\u2550\u2566\u2550\u2557", "\u2551 \u2551 \u2551", "\u2560\u2550\u256c\u2550\u2563", "\u2551 \u2551 \u2551", "\u255a\u2550\u2569\u2550\u255d"}),
    BOLD(new String[]{"\u250f\u2501\u2533\u2501\u2513", "\u2503 \u2503 \u2503", "\u2523\u2501\u254b\u2501\u252b", "\u2503 \u2503 \u2503", "\u2517\u2501\u253b\u2501\u251b"}),
    HYBRID_BOLD_SINGLE(new String[]{"\u250f\u2501\u252f\u2501\u2513", "\u2503 \u2502 \u2503", "\u2520\u2500\u253c\u2500\u2528", "\u2503 \u2502 \u2503", "\u2517\u2501\u2537\u2501\u251b"}),
    HYBRID_SINGLE_BOLD(new String[]{"\u250c\u2500\u2530\u2500\u2510", "\u2502 \u2503 \u2502", "\u251d\u2501\u254b\u2501\u2525", "\u2502 \u2503 \u2502", "\u2514\u2500\u2538\u2500\u2518"}),
    BOLD_HEADER_SINGLE_BODY(new String[]{"\u250f\u2501\u2533\u2501\u2513", "\u2503 \u2503 \u2503", "\u2521\u2501\u2547\u2501\u2529", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    SINGLE_HEADER_BOLD_BODY(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u2522\u2501\u2548\u2501\u252a", "\u2503 \u2503 \u2503", "\u2517\u2501\u253b\u2501\u251b"}),
    HYBRID_BOLD_HEADER_SINGLE_BODY(new String[]{"\u250f\u2501\u252f\u2501\u2513", "\u2503 \u2502 \u2503", "\u2521\u2501\u253f\u2501\u2529", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    HYBRID_SINGLE_HEADER_BOLD_BODY(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u2522\u2501\u253f\u2501\u252a", "\u2503 \u2502 \u2503", "\u2517\u2501\u2537\u2501\u251b"}),
    HYBRID_DOUBLE_SINGLE(new String[]{"\u2554\u2550\u2564\u2550\u2557", "\u2551 \u2502 \u2551", "\u2560\u2550\u256a\u2550\u2563", "\u2551 \u2502 \u2551", "\u255a\u2550\u2567\u2550\u255d"}),
    HYBRID_SINGLE_DOUBLE(new String[]{"\u250c\u2500\u2565\u2500\u2510", "\u2502 \u2551 \u2502", "\u251c\u2500\u256b\u2500\u2524", "\u2502 \u2551 \u2502", "\u2514\u2500\u2568\u2500\u2518"}),
    DOUBLE_BORDER_SINGLE_CONTENT(new String[]{"\u2554\u2550\u2564\u2550\u2557", "\u2551 \u2502 \u2551", "\u255f\u2500\u253c\u2500\u2562", "\u2551 \u2502 \u2551", "\u255a\u2550\u2567\u2550\u255d"}),
    SINGLE_BORDER_DOUBLE_CONTENT(new String[]{"\u250c\u2500\u2565\u2500\u2510", "\u2502 \u2551 \u2502", "\u255e\u2550\u256c\u2550\u2561", "\u2502 \u2551 \u2502", "\u2514\u2500\u2568\u2500\u2518"}),
    ASCII(new String[]{"/-+-\\", "| | |", "+-+-+", "| | |", "\\-+-/"}),
    BLANK(new String[]{"     ", "     ", "     ", "     ", "     "}),
    SINGLE_BLANK(new String[]{" \u2500 \u2500 ", "     ", " \u2500 \u2500 ", "     ", " \u2500 \u2500 "}),
    ASCII_BLANK(new String[]{" - - ", "     ", " - - ", "     ", " - - "});

    public static final TextBoxStyle UNICODE_TEXT_BOX_STYLE;
    public static final TextBoxStyle WINDOWS_TEXT_BOX_STYLE;
    public static final TextBoxStyle ASCII_TEXT_BOX_STYLE;
    private TextBoxGrid _textBoxGrid;

    private TextBoxStyle(String[] aTextBoxStyle) {
        this._textBoxGrid = new TextBoxGridImpl(aTextBoxStyle);
    }

    public Character getLeftEdge() {
        return (Character)this._textBoxGrid.getLeftEdge();
    }

    public Character getTopLeftEdge() {
        return (Character)this._textBoxGrid.getTopLeftEdge();
    }

    public Character getDividerEdge() {
        return (Character)this._textBoxGrid.getDividerEdge();
    }

    public Character getTopDividerEdge() {
        return (Character)this._textBoxGrid.getTopDividerEdge();
    }

    public Character getTopRightEdge() {
        return (Character)this._textBoxGrid.getTopRightEdge();
    }

    public Character getRightEdge() {
        return (Character)this._textBoxGrid.getRightEdge();
    }

    public Character getLeftLine() {
        return (Character)this._textBoxGrid.getLeftLine();
    }

    public Character getDividerLine() {
        return (Character)this._textBoxGrid.getDividerLine();
    }

    public Character getRightLine() {
        return (Character)this._textBoxGrid.getRightLine();
    }

    public Character getTopLine() {
        return (Character)this._textBoxGrid.getTopLine();
    }

    public Character getBottomRightEdge() {
        return (Character)this._textBoxGrid.getBottomRightEdge();
    }

    public Character getBottomDividerEdge() {
        return (Character)this._textBoxGrid.getBottomDividerEdge();
    }

    public Character getBottomLeftEdge() {
        return (Character)this._textBoxGrid.getBottomLeftEdge();
    }

    public Character getBottomLine() {
        return (Character)this._textBoxGrid.getBottomLine();
    }

    public Character getInnerLine() {
        return (Character)this._textBoxGrid.getInnerLine();
    }

    public static TextBoxGrid toTextBoxGrid(String aValue) {
        aValue = aValue != null ? aValue.replaceAll("-", "").replaceAll("_", "") : aValue;
        for (TextBoxStyle eValue : TextBoxStyle.values()) {
            if (!eValue.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(aValue)) continue;
            return eValue;
        }
        return null;
    }

    public static TextBoxGrid toExecutionTextBoxGrid() {
        return switch (Terminal.toCharSetCapability()) {
            default -> throw new IncompatibleClassChangeError();
            case Terminal.CharSetCapability.UNICODE -> UNICODE_TEXT_BOX_STYLE;
            case Terminal.CharSetCapability.WINDOWS -> WINDOWS_TEXT_BOX_STYLE;
            case Terminal.CharSetCapability.ASCII -> ASCII_TEXT_BOX_STYLE;
        };
    }

    static {
        UNICODE_TEXT_BOX_STYLE = HYBRID_BOLD_SINGLE;
        WINDOWS_TEXT_BOX_STYLE = SINGLE;
        ASCII_TEXT_BOX_STYLE = ASCII;
    }
}

