/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import org.refcodes.struct.PathMap;
import org.refcodes.struct.TypeUtility;

public class StructureUtility {
    public static final String SYSTEM_PROPERTY_STRUCT_KEEP_MAPS = "struct.keepMaps";
    public static final String ENVIRONMENT_VARIABLE_STRUCT_KEEP_MAPS = "STRUCT_KEEPMAPS";
    private static Boolean _isKeepMaps = null;

    private StructureUtility() {
    }

    public static <T> void retrieveFrom(PathMap<T> aFromPathMap, String aFromPath, PathMap.PathMapBuilder<T> aToPathMap) {
        String theFromPath = StructureUtility.toGenericPath(aFromPathMap, aFromPath);
        for (String ePath : aFromPathMap.paths()) {
            String eToPath;
            if (!ePath.startsWith(theFromPath) || !(eToPath = ePath.substring(theFromPath.length())).startsWith(aFromPathMap.getRootPath()) && !eToPath.isEmpty()) continue;
            aToPathMap.put(eToPath, aFromPathMap.get((Object)ePath));
        }
    }

    public static <T> void retrieveTo(PathMap<T> aFromPathMap, String aToPath, PathMap.PathMapBuilder<T> aToPathMap) {
        String thetoPath = StructureUtility.toGenericPath(aFromPathMap, aToPath);
        for (String ePath : aFromPathMap.paths()) {
            aToPathMap.put(thetoPath + ePath, aFromPathMap.get((Object)ePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Object toDataStructure(PathMap<?> aPathMap, String aFromPath) {
        if (_isKeepMaps == null) {
            Class<StructureUtility> clazz = StructureUtility.class;
            // MONITORENTER : org.refcodes.struct.StructureUtility.class
            if (_isKeepMaps == null) {
                _isKeepMaps = System.getProperty(SYSTEM_PROPERTY_STRUCT_KEEP_MAPS) != null ? Boolean.valueOf(Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_STRUCT_KEEP_MAPS))) : (System.getenv(ENVIRONMENT_VARIABLE_STRUCT_KEEP_MAPS) != null ? Boolean.valueOf(Boolean.parseBoolean(System.getenv(ENVIRONMENT_VARIABLE_STRUCT_KEEP_MAPS))) : Boolean.valueOf(false));
            }
            // MONITOREXIT : clazz
        }
        if (_isKeepMaps == false) return TypeUtility.toUnwrappedMap(aPathMap.toMap(aFromPath));
        return aPathMap.toMap(aFromPath);
    }

    public static String toGenericPath(PathMap<?> aPathMap, String aPath) {
        aPath = aPathMap.toNormalizedPath(aPath);
        while (aPath.endsWith("" + aPathMap.getDelimiter())) {
            aPath = aPath.substring(0, aPath.length() - 1);
        }
        return aPath;
    }
}

