/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.schema;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.refcodes.mixin.Bytes;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.schema.Schema;
import org.refcodes.schema.SchemaVisitor;

public class XmlVisitor
implements SchemaVisitor<String> {
    private static final String INDENT = "  ";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String ARRAY_ELEMENT = "ARRAY";
    private static final String INDEX_ATTRIBUTE = "index";
    private static final String NULL = "NULL";

    @Override
    public String visit(Schema aSchema, Collection<String> aResults) {
        if (aSchema != null) {
            StringBuilder theBuffer = new StringBuilder();
            theBuffer.append("<");
            String theSchemaElement = aSchema.getType().getSimpleName().toUpperCase();
            theBuffer.append(theSchemaElement);
            theBuffer.append(" ");
            theBuffer.append(TYPE_ATTRIBUTE);
            theBuffer.append("=\"");
            theBuffer.append(aSchema.getType().getName());
            theBuffer.append("\">");
            ArrayList theKeys = new ArrayList(aSchema.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                theBuffer.append(System.lineSeparator());
                Object eObj = aSchema.get(eKey);
                String eValue = this.toString(eObj);
                theBuffer.append(INDENT);
                theBuffer.append('<');
                theBuffer.append(eKey);
                theBuffer.append('>');
                theBuffer.append(eValue);
                if (eObj != null && eObj.getClass().isArray()) {
                    theBuffer.append(INDENT);
                }
                theBuffer.append("</");
                theBuffer.append(eKey);
                theBuffer.append('>');
            }
            if (aResults != null && aResults.size() != 0) {
                for (String eResult : aResults) {
                    eResult = eResult.indent(INDENT.length()).stripTrailing();
                    if (theBuffer.charAt(theBuffer.length() - 1) == '\"' || theBuffer.charAt(theBuffer.length() - 1) == '}') {
                        theBuffer.append(',');
                    }
                    theBuffer.append(System.lineSeparator());
                    theBuffer.append(eResult);
                }
            }
            if (theBuffer.charAt(theBuffer.length() - 1) != '{') {
                theBuffer.append(System.lineSeparator());
            }
            theBuffer.append("</");
            theBuffer.append(theSchemaElement);
            theBuffer.append('>');
            return theBuffer.toString();
        }
        return "<NULL/>";
    }

    protected String toString(Object aObj) {
        if (aObj != null && aObj.getClass().isArray()) {
            StringBuilder theBuffer = new StringBuilder();
            int theLength = Array.getLength(aObj);
            for (int i = 0; i < theLength; ++i) {
                theBuffer.append(System.lineSeparator());
                theBuffer.append(INDENT);
                theBuffer.append('<');
                theBuffer.append(ARRAY_ELEMENT);
                theBuffer.append(' ');
                theBuffer.append(INDEX_ATTRIBUTE);
                theBuffer.append("=\"");
                theBuffer.append(i);
                theBuffer.append("\">");
                Object eObj = Array.get(aObj, i);
                theBuffer.append(this.toString(eObj));
                if (eObj != null && eObj.getClass().isArray()) {
                    theBuffer.append(INDENT);
                }
                theBuffer.append("</");
                theBuffer.append(ARRAY_ELEMENT);
                theBuffer.append(">");
            }
            theBuffer.append(System.lineSeparator());
            return theBuffer.toString().indent(INDENT.length());
        }
        if (aObj instanceof String || aObj != null && aObj.getClass().isEnum()) {
            return String.valueOf(aObj);
        }
        if (aObj instanceof Character) {
            return String.valueOf(aObj);
        }
        if (aObj instanceof Byte) {
            return NumericalUtility.toHexString((byte)((Byte)aObj));
        }
        if (aObj instanceof Class) {
            return ((Class)aObj).getName();
        }
        if (aObj instanceof Exception) {
            return String.valueOf(aObj);
        }
        if (aObj instanceof Bytes) {
            Bytes bytes = (Bytes)aObj;
            return this.toString(bytes.toBytes());
        }
        return aObj != null ? aObj.toString() : null;
    }
}

