/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.refcodes.properties.AbstractResourcePropertiesDecorator;
import org.refcodes.properties.DocumentMetrics;
import org.refcodes.properties.DocumentNotation;
import org.refcodes.properties.JavaProperties;
import org.refcodes.properties.JsonProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.properties.TomlProperties;
import org.refcodes.properties.XmlProperties;
import org.refcodes.properties.YamlProperties;
import org.refcodes.runtime.ConfigLocator;

public class PolyglotProperties
extends AbstractResourcePropertiesDecorator<ResourceProperties> {
    public PolyglotProperties(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aResourceClass, aFilePath));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aResourceClass, aFilePath));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aResourceClass, aFilePath, aConfigLocator));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aResourceClass, aFilePath, aConfigLocator));
    }

    public PolyglotProperties(File aFile) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFile));
    }

    public PolyglotProperties(File aFile, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFile));
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFile, aConfigLocator));
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFile, aConfigLocator));
    }

    public PolyglotProperties(InputStream aInputStream) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aInputStream));
    }

    public PolyglotProperties(InputStream aInputStream, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aInputStream));
    }

    public PolyglotProperties(Map<?, ?> aMap) {
        super(new PolyglotPropertiesFactory().toProperties(aMap));
    }

    public PolyglotProperties(Map<?, ?> aMap, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aMap));
    }

    public PolyglotProperties(Object aObj) {
        super(new PolyglotPropertiesFactory().toProperties(aObj));
    }

    public PolyglotProperties(Object aObj, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aObj));
    }

    public PolyglotProperties(Properties aProperties) {
        super(new PolyglotPropertiesFactory().toProperties(aProperties));
    }

    public PolyglotProperties(Properties aProperties, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aProperties));
    }

    public PolyglotProperties(Properties.PropertiesBuilder aPropertiesBuilder) {
        super(new PolyglotPropertiesFactory().toProperties(aPropertiesBuilder));
    }

    public PolyglotProperties(Properties.PropertiesBuilder aPropertiesBuilder, DocumentMetrics aDocumentMetrics) {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aPropertiesBuilder));
    }

    public PolyglotProperties(String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFilePath));
    }

    public PolyglotProperties(String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFilePath));
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFilePath, aConfigLocator));
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aFilePath, aConfigLocator));
    }

    public PolyglotProperties(URL aUrl) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aUrl));
    }

    public PolyglotProperties(URL aUrl, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDocumentMetrics).toProperties(aUrl));
    }

    public static class PolyglotPropertiesFactory
    implements ResourcePropertiesFactory {
        private final List<ResourcePropertiesFactory> _factories = new ArrayList<ResourcePropertiesFactory>();

        public PolyglotPropertiesFactory() {
            this(DocumentNotation.DEFAULT);
        }

        public PolyglotPropertiesFactory(DocumentMetrics aDocumentMetrics) {
            this._factories.add(new TomlProperties.TomlPropertiesFactory(aDocumentMetrics));
            this._factories.add(new YamlProperties.YamlPropertiesFactory());
            this._factories.add(new XmlProperties.XmlPropertiesFactory(aDocumentMetrics));
            this._factories.add(new JsonProperties.JsonPropertiesFactory());
            this._factories.add(new JavaProperties.JavaPropertiesFactory(aDocumentMetrics));
        }

        public PolyglotPropertiesFactory(ResourcePropertiesFactory ... aFactories) {
            for (ResourcePropertiesFactory eFactory : aFactories) {
                this._factories.add(eFactory);
            }
        }

        public String[] getFilenameSuffixes() {
            ArrayList<String> theExtensions = new ArrayList<String>();
            for (ResourcePropertiesFactory _factorie : this._factories) {
                String[] eExtensions = _factorie.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    theExtensions.add(eExtension);
                }
            }
            return theExtensions.toArray(new String[theExtensions.size()]);
        }

        @Override
        public ResourceProperties toProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFilePath, aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties(aResourceClass, aFilePath, aConfigLocator);
                    }
                    catch (Exception e2) {
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        try {
                            return eFactory.toProperties(aResourceClass, aFilePath + eExtension, aConfigLocator);
                        }
                        catch (Exception e3) {
                            if (theCause != null) continue;
                            theCause = e3;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with name (scheme) <" + aFilePath + "> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
            }
        }

        @Override
        public ResourceProperties toProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFile.getPath(), aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties(aFile, aConfigLocator);
                    }
                    catch (Exception e2) {
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        File eFile = new File(aFile.getAbsolutePath() + eExtension);
                        try {
                            return eFactory.toProperties(eFile, aConfigLocator);
                        }
                        catch (Exception e3) {
                            if (theCause != null) continue;
                            theCause = e3;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with name (scheme) <" + String.valueOf(aFile.toPath()) + "> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
            }
        }

        @Override
        public ResourceProperties toProperties(InputStream aInputStream) throws IOException, ParseException {
            Exception theCause = null;
            byte[] theBytes = PolyglotPropertiesFactory.toByteArray(aInputStream);
            for (ResourcePropertiesFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(new ByteArrayInputStream(theBytes));
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file for the given InputStream found!");
        }

        @Override
        public ResourceProperties toProperties(Map<?, ?> aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(Object aObj) {
            return this._factories.get(0).toProperties(aObj);
        }

        @Override
        public ResourceProperties toProperties(Properties aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(Properties.PropertiesBuilder aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return this.toProperties(null, aFilePath, aConfigLocator);
        }

        @Override
        public ResourceProperties toProperties(URL aUrl) throws IOException, ParseException {
            Exception theCause;
            block12: {
                theCause = null;
                try {
                    ResourcePropertiesFactory theFactory = this.fromFilenameExtension(aUrl.toExternalForm());
                    if (theFactory != null) {
                        return theFactory.toProperties(aUrl);
                    }
                }
                catch (Exception e) {
                    if (theCause != null) break block12;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(aUrl);
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    URL eUrl = new URL(aUrl.toExternalForm() + eExtension);
                    try {
                        return eFactory.toProperties(eUrl);
                    }
                    catch (Exception e) {
                        if (theCause != null) continue;
                        theCause = e;
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with (base) URL <" + aUrl.toExternalForm() + "> found!");
        }

        private ResourcePropertiesFactory fromFilenameExtension(String aFilePath) {
            for (ResourcePropertiesFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    if (!aFilePath.endsWith(eExtension)) continue;
                    return eFactory;
                }
            }
            return null;
        }

        private ResourceProperties toPropertiesFromFilePath(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause;
            block17: {
                theCause = null;
                File theFile = new File(aFilePath);
                if (theFile.exists()) {
                    try {
                        ResourcePropertiesFactory theFactory = this.fromFilenameExtension(theFile.getAbsolutePath());
                        if (theFactory != null) {
                            return theFactory.toProperties(theFile, ConfigLocator.ABSOLUTE);
                        }
                    }
                    catch (IOException | ParseException e) {
                        if (theCause != null) break block17;
                        theCause = e;
                    }
                } else {
                    File eFile;
                    for (ResourcePropertiesFactory eFactory : this._factories) {
                        for (String eExtension : eFactory.getFilenameSuffixes()) {
                            eFile = new File(aFilePath + eExtension);
                            if (!eFile.exists()) continue;
                            try {
                                return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                            }
                            catch (IOException | ParseException e) {
                                if (theCause != null) continue;
                                theCause = e;
                            }
                        }
                    }
                    if (aConfigLocator != null && aConfigLocator != ConfigLocator.ABSOLUTE) {
                        for (File eDir : aConfigLocator.getFolders()) {
                            for (ResourcePropertiesFactory eFactory : this._factories) {
                                for (String eExtension : eFactory.getFilenameSuffixes()) {
                                    eFile = new File(eDir, aFilePath + eExtension);
                                    if (!eFile.exists()) continue;
                                    try {
                                        return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                                    }
                                    catch (IOException | ParseException e) {
                                        if (theCause != null) continue;
                                        theCause = e;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with name (scheme) <" + aFilePath + "> found, where the suffix may by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
        }

        public static byte[] toByteArray(InputStream aInputStream) throws IOException {
            int eRead;
            ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
            byte[] theData = new byte[16384];
            while ((eRead = aInputStream.read(theData, 0, theData.length)) != -1) {
                theBuffer.write(theData, 0, eRead);
            }
            theBuffer.flush();
            return theBuffer.toByteArray();
        }
    }
}

